/* LoadSelectionConfigCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.config.LoadSelectionConfigDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.util.BoardTools;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	public class LoadSelectionConfigCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		public function execute(event:CairngormEvent):void
		{
			var delegate: LoadSelectionConfigDelegate = new LoadSelectionConfigDelegate(this);
			model.config.selectionConfigLoaded = false;
			delegate.loadSelectionConfig(model.logArea);
		}
		
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;
			BoardTools.applySelectionLists(model.config, xml);
			model.config.selectionConfigLoaded = true;
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error loading selection configuration for display board: " + super.getFaultMessage(faultEvent);
		}
		
	}
}