/* LoadActivityReportCommand.as */
	
package gov.va.med.edp.command.reports
{
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.factory.ReportFactory;
	
	import mx.rpc.events.ResultEvent;

	public class LoadSummaryReportCommand extends BaseReportCommand
	{
		
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			// process the xml
			//add summaryVO data to model
			model.reports.summaryReport.summaryVO = ReportFactory.buildSummaryVOFromXML(xml.averages.average);
			//add delay chart data to model..
			model.reports.summaryReport.delayLogs = ReportFactory.buildSummaryDelayChartFromXML(xml.delayChart.delay);
									
			//fire the binding..
			model.reports.reportType = "";
			model.reports.reportType = ReportEvent.EVENT_SUMMARY_REPORT;
		}
		
	}
}