/* LoadActivityReportCommand.as */
	
package gov.va.med.edp.command.reports
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.reports.ReportDelegate;
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.factory.ReportFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import mx.rpc.events.ResultEvent;

	public class LoadVaAdmissionsReportCommand extends BaseReportCommand
	{
		
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			// process the xml
			//add log enteries to model
			model.reports.vaAdmissionsReport.admissionLogs = ReportFactory.buildReportLogEntriesFromXML(xml.logEntries.log);
			//add averages to model..
			model.reports.vaAdmissionsReport.admissionAverages = ReportFactory.buildReportAveragesFromXML(xml.averages.average);
									
			//fire the binding..
			model.reports.reportType = "";
			model.reports.reportType = ReportEvent.EVENT_VA_ADMISSIONS_REPORT;
		}
		
	}
}