package gov.va.med.edp.pt.demog.model {

import gov.va.med.edp.pt.demog.model.TestPatientCheckVO;
import gov.va.med.edp.pt.demog.model.PatientCheckVO;

import flexunit.framework.TestCase;

public class TestPatientChecksModel extends TestCase {

    private var m:PatientChecksModel = new PatientChecksModel();

    public override function setUp():void {
        // this setup simulates patient checks
        m = new PatientChecksModel();
        m.checkState = PatientChecksModel.STATE_LOADING; // simulate loading

        m.patientChecks = new PatientCheckVO();
        m.patientChecks.dfn = "foobar";
    }

    public function testCreate():void {
        m = new PatientChecksModel();
        assertEquals(PatientChecksModel.STATE_NONE, m.checkState);
        assertNull(m.patientChecks);
        assertFalse(m.patientChecksReady);
        assertFalse(m.continueEnabled);
        assertFalse(m.backEnabled);
    }

    public function testReset():void {
        m.reset();
        assertNull(m.patientChecks);
        assertFalse(m.patientChecksReady);
        assertFalse(m.continueEnabled);
        assertFalse(m.backEnabled);
    }

    public function testAlreadyOnBoardCheck():void {
        m.patientChecks.onBoardText = "FOO,BAR";
        m.patientChecksReady = true;

        assertEquals(PatientChecksModel.STATE_LOADED, m.checkState);
        assertTrue(m.continueEnabled);
        assertFalse(m.backEnabled);

        m.forward();

        assertEquals(PatientChecksModel.STATE_ONBOARD, m.checkState);
        assertFalse(m.continueEnabled);
        assertTrue(m.backEnabled);

        m.back();

        assertEquals(PatientChecksModel.STATE_LOADED, m.checkState);
        assertTrue(m.continueEnabled);
        assertFalse(m.backEnabled);
    }

    public function testCycleThroughSimilarNamesSensitiveDeceasedAndFlagsPatientChecks():void {
        m.patientChecks.similarNames = TestPatientCheckVO.createPtList();
        m.patientChecks.deceasedText = "This patient died on Jan 24, 2007.\nDo you wish to continue?";
        m.patientChecks.flags = TestPatientCheckVO.createPtFlags();
        m.patientChecksReady = true;

        assertEquals(PatientChecksModel.STATE_LOADED, m.checkState);
        assertTrue(m.continueEnabled);
        assertFalse(m.backEnabled);

        m.forward();

        assertEquals(PatientChecksModel.STATE_SIMILAR, m.checkState);
        assertTrue(m.continueEnabled);
        assertTrue(m.backEnabled);

        m.forward();

        assertEquals(PatientChecksModel.STATE_DECEASED, m.checkState);
        assertTrue(m.continueEnabled);
        assertTrue(m.backEnabled);

        m.forward();

        assertEquals(PatientChecksModel.STATE_FLAGS, m.checkState);
        assertTrue(m.continueEnabled);
        assertTrue(m.backEnabled);

        m.back();

        assertEquals(PatientChecksModel.STATE_DECEASED, m.checkState);
        assertTrue(m.continueEnabled);
        assertTrue(m.backEnabled);

        m.back();

        assertEquals(PatientChecksModel.STATE_SIMILAR, m.checkState);
        assertTrue(m.continueEnabled);
        assertTrue(m.backEnabled);

        m.back();

        assertEquals(PatientChecksModel.STATE_LOADED, m.checkState);
        assertTrue(m.continueEnabled);
        assertFalse(m.backEnabled);

        m.forward();
        m.forward();
        m.forward();

        m.forward();

        assertEquals(PatientChecksModel.STATE_ALLOW, m.checkState);
        assertFalse(m.continueEnabled);
        assertFalse(m.backEnabled);
    }

    public function testMayAccessSensitivePatient():void {
        m.patientChecks.sensitive = true;
        m.patientChecks.warningText = "unable to access this patient";
        m.patientChecks.mayAccess = false;
        m.patientChecksReady = true;

        assertEquals(PatientChecksModel.STATE_LOADED, m.checkState);
        assertTrue(m.continueEnabled);
        assertFalse(m.backEnabled);

        m.forward();

        assertEquals(PatientChecksModel.STATE_SENSITIVE, m.checkState);
        assertFalse(m.continueEnabled);
        assertTrue(m.backEnabled);

        m.back();

        assertEquals(PatientChecksModel.STATE_LOADED, m.checkState);
        assertTrue(m.continueEnabled);
        assertFalse(m.backEnabled);
    }
}
}