/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.spi;

import gov.va.med.environment.Environment;
import gov.va.med.environment.ServerType;
import gov.va.med.exception.ExceptionUtils;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionFactory;
import gov.va.med.vistalink.adapter.cci.VistaLinkResourceException;
import gov.va.med.vistalink.adapter.heartbeat.VistaHeartBeatTimerManager;
import gov.va.med.vistalink.adapter.spi.ConfigurationReader;
import gov.va.med.vistalink.adapter.spi.EMAdapterEnvironment;
import gov.va.med.vistalink.adapter.spi.VistaLinkConnectionRequestInfo;
import gov.va.med.vistalink.adapter.spi.VistaLinkManagedConnection;
import gov.va.med.vistalink.adapter.spi.VistaLinkRuntimeInfo;
import gov.va.med.vistalink.adapter.spi.VistaLinkSystemInfoVO;
import gov.va.med.vistalink.institution.InstitutionMapManager;
import gov.va.med.vistalink.institution.InstitutionMappingImpl;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class VistaLinkManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    public static final String ADAPTER_VERSION = "1.5";
    public static final String ADAPTER_FULL_VERSION = "1.5.0.026";
    public static final String CONNECTOR_PROPERTY_NAME = "connectorJndiName";
    private static final int HEARTBEAT_RATE_MULTIPLIER = 2;
    private int hashCode;
    private static final long J2EE_DEFAULT_SOCKET_TIMEOUT = 5000L;
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$vistalink$adapter$spi$VistaLinkManagedConnectionFactory == null ? (class$gov$va$med$vistalink$adapter$spi$VistaLinkManagedConnectionFactory = VistaLinkManagedConnectionFactory.class$("gov.va.med.vistalink.adapter.spi.VistaLinkManagedConnectionFactory")) : class$gov$va$med$vistalink$adapter$spi$VistaLinkManagedConnectionFactory));
    private long defaultJ2EETimeOut = 5000L;
    private boolean alwaysUseDefaultAsMin = true;
    private String hostIpAddress;
    private String primaryStation = "";
    private String primaryStationSuffix = "";
    private InetAddress hostIpAddressResolved = null;
    private int hostPort;
    private String accessCode;
    private String verifyCode;
    private String connectorJndiName = "";
    private VistaLinkConnectionFactory cf;
    private boolean connectorEnabled = false;
    private int maxConnectionHandles = 1;
    private PrintWriter printWriter;
    private int heartBeatRateMultiplierForSocketTimeOut;
    private VistaHeartBeatTimerManager timerManager;
    private EMAdapterEnvironment adapterEnvironment = EMAdapterEnvironment.J2SE;
    private long managedConnectionCount = 0L;
    private Object mcCountSyncObj = new Object();
    private static long managedFactoryCount = 0L;
    private static Object mfCountSyncObj = new Object();
    private long distinguishedIdentifier = 0L;
    private long connectionFailureCount = 0L;
    private long connectionAuthFailureCount = 0L;
    private long divisionMismatchCount = 0L;
    private long identityFailureCount = 0L;
    private long productionMismatchCount = 0L;
    private Object healthSyncObj = new Object();
    private long createConnectionHandleCount = 0L;
    private long createConnectionHandleTotalMillis = 0L;
    private Object createConnectionHandleAvgSyncObj = new Object();
    private long matchManagedConnectionCount = 0L;
    private long matchManagedConnectionTotalMillis = 0L;
    private Object matchManagedConnectionAvgSyncObj = new Object();
    private String parseConfigFailureMessage = null;
    private HashSet mcSet = new HashSet();
    static /* synthetic */ Class class$gov$va$med$vistalink$adapter$spi$VistaLinkManagedConnectionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VistaLinkManagedConnectionFactory() {
        Object object = mfCountSyncObj;
        synchronized (object) {
            this.distinguishedIdentifier = ++managedFactoryCount;
        }
        this.setHashCode();
        this.hostIpAddressResolved = null;
        this.timerManager = new VistaHeartBeatTimerManager();
        this.timerManager.setAdapterEnvironment(this.adapterEnvironment);
        this.setHeartBeatRateMultiplierForSocketTimeOut(2);
        if (logger.isDebugEnabled()) {
            String debugMsg = this.getLoggerFormattedString("Constructed");
            logger.debug((Object)debugMsg);
        }
    }

    public Object createConnectionFactory(ConnectionManager mgr) throws ResourceException {
        if (logger.isDebugEnabled()) {
            String loggerMsg = this.getLoggerFormattedString("createConnectionFactory->managed");
            logger.debug((Object)loggerMsg);
        }
        this.cf = new VistaLinkConnectionFactory(this, mgr);
        return this.cf;
    }

    public Object createConnectionFactory() throws ResourceException {
        if (logger.isDebugEnabled()) {
            String loggerMsg = this.getLoggerFormattedString("createConnectionFactory->unmanaged");
            logger.debug((Object)loggerMsg);
        }
        this.cf = new VistaLinkConnectionFactory(this, null);
        return this.cf;
    }

    public VistaLinkSystemInfoVO getSystemInfo() {
        VistaLinkManagedConnection mc = null;
        VistaLinkSystemInfoVO systemInfoVO = null;
        try {
            mc = (VistaLinkManagedConnection)this.createManagedConnection(null, null);
            systemInfoVO = mc.executeSystemInfoInteraction().getSystemInfoVO();
            mc.destroy();
        }
        catch (Exception e) {
            logger.error((Object)e);
            systemInfoVO = new VistaLinkSystemInfoVO();
            systemInfoVO.setErrorMessage(e.toString());
        }
        return systemInfoVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        try {
            if (!this.connectorEnabled) {
                StringBuffer failureMessage = new StringBuffer("Connector '");
                failureMessage.append(this.connectorJndiName);
                failureMessage.append("' is disabled; check vistalink config file. Not returning connection.");
                if (this.parseConfigFailureMessage != null) {
                    failureMessage.append(" Deploy-time failure was: '");
                    failureMessage.append(this.parseConfigFailureMessage);
                    failureMessage.append("'; fix config file and redeploy connector.");
                }
                throw new VistaLinkResourceException(failureMessage.toString());
            }
            this.setHostIpAddressResolved(this.hostIpAddress);
            long mcDistinguishedIdentifier = 0L;
            Object object = this.mcCountSyncObj;
            synchronized (object) {
                mcDistinguishedIdentifier = ++this.managedConnectionCount;
            }
            if (logger.isDebugEnabled()) {
                String loggerMsg = this.getLoggerFormattedString("Creating Managed connection->" + mcDistinguishedIdentifier);
                logger.debug((Object)loggerMsg);
            }
            VistaLinkManagedConnection mc = new VistaLinkManagedConnection(this, mcDistinguishedIdentifier);
            if (logger.isDebugEnabled()) {
                String loggerMsg = this.getLoggerFormattedString("Created Managed connection->" + mcDistinguishedIdentifier);
                logger.debug((Object)loggerMsg);
            }
            this.mcSet.add(mc);
            return mc;
        }
        catch (UnknownHostException e) {
            String errMsg = "Unknown Host";
            if (logger.isEnabledFor(Priority.ERROR)) {
                String loggerMsg = this.getLoggerFormattedStringWStackTrace(errMsg, e);
                logger.error((Object)loggerMsg);
            }
            throw new VistaLinkResourceException(errMsg, e);
        }
        catch (VistaLinkResourceException e) {
            if (logger.isEnabledFor(Priority.ERROR)) {
                String loggerMsg = this.getLoggerFormattedStringWStackTrace("Resource exception occurred in creatingManagedConnection()", (Throwable)((Object)e));
                logger.error((Object)loggerMsg);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isEnabledFor(Priority.ERROR)) {
                String loggerMsg = this.getLoggerFormattedStringWStackTrace("Unexpected exception occured in creatingManagedConnection()", e);
                logger.error((Object)loggerMsg);
            }
            throw new VistaLinkResourceException(e);
        }
    }

    protected void removeMc(VistaLinkManagedConnection mc) {
        this.mcSet.remove(mc);
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        String loggerMsg;
        long beginTimeMillis = System.currentTimeMillis();
        VistaLinkManagedConnection nullConnSpecConnection = null;
        VistaLinkManagedConnection lastConnection = null;
        VistaLinkManagedConnection returnConnection = null;
        boolean foundMatchWithOutConnSpec = false;
        if (logger.isDebugEnabled()) {
            loggerMsg = this.getLoggerFormattedString("matchManagedConnection: Pool Size: " + connectionSet.size());
            logger.debug((Object)loggerMsg);
        }
        VistaLinkConnectionRequestInfo vlConReqInfo = (VistaLinkConnectionRequestInfo)info;
        if (info != null && logger.isDebugEnabled()) {
            loggerMsg = this.getLoggerFormattedString("matchManagedConnection->" + info.toString());
            logger.debug((Object)loggerMsg);
        }
        Iterator it = connectionSet.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof VistaLinkManagedConnection)) continue;
            VistaLinkManagedConnection mc = (VistaLinkManagedConnection)obj;
            if (logger.isDebugEnabled()) {
                loggerMsg = this.getLoggerFormattedString("matchManagedConnection->" + mc.toString() + "->" + mc.getConnReqInfoString());
                logger.debug((Object)loggerMsg);
            }
            if (!this.mcSet.contains(mc)) continue;
            lastConnection = mc;
            if (vlConReqInfo.equals(mc.getConnReqInfo())) {
                if (logger.isDebugEnabled()) {
                    loggerMsg = this.getLoggerFormattedString("matchManagedConnection->Found match with matching connection request info->" + mc.toString() + "->" + mc.getConnReqInfoString());
                    logger.debug((Object)loggerMsg);
                }
                long elapsedMillis = System.currentTimeMillis() - beginTimeMillis;
                this.addMatchManagedConnectionTime(elapsedMillis);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)this.getLoggerFormattedString("matchManagedConnections(...) processing time [match found] == " + elapsedMillis));
                }
                return mc;
            }
            if (foundMatchWithOutConnSpec) continue;
            if (mc.getConnReqInfo() == null) {
                foundMatchWithOutConnSpec = true;
                nullConnSpecConnection = mc;
            }
            if (!logger.isDebugEnabled()) continue;
            loggerMsg = this.getLoggerFormattedString("matchManagedConnection->no match on request info->" + mc.toString() + "->" + mc.getConnReqInfoString());
            logger.debug((Object)loggerMsg);
        }
        returnConnection = nullConnSpecConnection != null ? nullConnSpecConnection : lastConnection;
        long elapsedMillis = System.currentTimeMillis() - beginTimeMillis;
        this.addMatchManagedConnectionTime(elapsedMillis);
        if (logger.isInfoEnabled()) {
            logger.info((Object)this.getLoggerFormattedString("matchManagedConnections(...) processing time [match not found] == " + elapsedMillis));
        }
        return returnConnection;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        if (this.printWriter == null) {
            String errMsg = "Log writer is null";
            if (logger.isEnabledFor(Priority.ERROR)) {
                String loggerMsg = this.getLoggerFormattedString(errMsg);
                logger.error((Object)loggerMsg);
            }
            throw new VistaLinkResourceException(errMsg);
        }
        return this.printWriter;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.printWriter = out;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VistaLinkManagedConnectionFactory)) {
            return false;
        }
        VistaLinkManagedConnectionFactory objMcf = (VistaLinkManagedConnectionFactory)obj;
        return objMcf.distinguishedIdentifier == this.distinguishedIdentifier;
    }

    private void setHashCode() {
        int HASHCODE_SEED;
        int returnVal = HASHCODE_SEED = 17;
        int distIdHashCode = (int)(this.distinguishedIdentifier ^ this.distinguishedIdentifier >>> 32);
        this.hashCode = returnVal = 37 * returnVal + distIdHashCode;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        String adapterEnvironmentString = "";
        if (this.adapterEnvironment != null) {
            adapterEnvironmentString = this.adapterEnvironment.toString();
        }
        return this.getClass().getName() + "[]" + this.hostIpAddress + "[]" + this.hostPort + "[]" + this.maxConnectionHandles + "[adapterversion]" + ADAPTER_FULL_VERSION + "[]" + adapterEnvironmentString + "[fdi]" + this.distinguishedIdentifier;
    }

    public int getMaxConnectionHandles() {
        return this.maxConnectionHandles;
    }

    private void setMaxConnectionHandles(int maxConnectionHandles) {
        this.maxConnectionHandles = maxConnectionHandles;
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public void setNonManagedHostPort(int hostPort) {
        this.hostPort = hostPort;
        this.setJ2SEProperties();
    }

    public void setNonManagedHostIPAddress(String hostipaddress) {
        this.hostIpAddress = hostipaddress;
        this.setJ2SEProperties();
    }

    private String getHostIPAddress() {
        return this.hostIpAddress;
    }

    private String getLoggerFormattedString(String log) {
        return this.toString() + "\n\t" + log;
    }

    private String getLoggerFormattedStringWStackTrace(Throwable e) {
        return this.getLoggerFormattedString(ExceptionUtils.getFullStackTrace((Throwable)e));
    }

    private String getLoggerFormattedStringWStackTrace(String log, Throwable e) {
        return this.getLoggerFormattedString(log + "\n\t" + ExceptionUtils.getFullStackTrace((Throwable)e));
    }

    public int getHeartBeatRateMultiplierForSocketTimeOut() {
        return this.heartBeatRateMultiplierForSocketTimeOut;
    }

    public void setHeartBeatRateMultiplierForSocketTimeOut(int heartBeatRateMultiplierForSocketTimeOut) {
        this.heartBeatRateMultiplierForSocketTimeOut = heartBeatRateMultiplierForSocketTimeOut;
    }

    protected long getSocketTimeOut() {
        if (this.adapterEnvironment.equals(EMAdapterEnvironment.J2SE)) {
            return this.getHeartBeatRateMultiplierForSocketTimeOut() * (int)this.timerManager.getHeartBeatRate();
        }
        return this.getDefaultJ2EETimeOut();
    }

    protected VistaHeartBeatTimerManager getHeartBeatTimerManager() {
        return this.timerManager;
    }

    public String getAccessCode() {
        return this.accessCode;
    }

    public String getVerifyCode() {
        return this.verifyCode;
    }

    public void setNonManagedAccessCode(String string) {
        this.accessCode = string;
        this.setJ2SEProperties();
    }

    public void setNonManagedVerifyCode(String string) {
        this.verifyCode = string;
        this.setJ2SEProperties();
    }

    private void setHostIpAddressResolved(String address) throws UnknownHostException {
        if (this.hostIpAddressResolved != null) {
            return;
        }
        this.hostIpAddressResolved = InetAddress.getByName(address);
    }

    public InetAddress getHostIpAddressResolved() {
        return this.hostIpAddressResolved;
    }

    public String getHostIpAddressUnresolved() {
        return this.hostIpAddress;
    }

    public EMAdapterEnvironment getAdapterEnvironment() {
        return this.adapterEnvironment;
    }

    public void setAdapterEnvironment(EMAdapterEnvironment adapterEnvironment) {
        this.adapterEnvironment = adapterEnvironment;
        this.timerManager.setAdapterEnvironment(this.adapterEnvironment);
    }

    protected long getManagedConnectionCount() {
        return this.managedConnectionCount;
    }

    public long getDistinguishedIdentifier() {
        return this.distinguishedIdentifier;
    }

    public void setConnectorJndiName(String connectorJndiName) {
        this.connectorJndiName = connectorJndiName;
        this.setAdapterEnvironment(EMAdapterEnvironment.J2EE);
        this.parseConfigFailureMessage = null;
        try {
            ConfigurationReader.parseConfig(this);
            if (logger.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer("connector Config JndiName: ");
                sb.append(connectorJndiName);
                sb.append("connector Config IP: ");
                sb.append(this.hostIpAddress);
                sb.append("connector Config Port: ");
                sb.append(this.hostPort);
                sb.append("connector Config Access code: <masked>\nconnector Config Verify code: <masked>");
                sb.append("connector Config Status: ");
                sb.append(this.connectorEnabled);
                logger.debug((Object)sb.toString());
            }
        }
        catch (VistaLinkResourceException e) {
            this.parseConfigFailureMessage = e.getMessage();
            String loggerMsg = this.getLoggerFormattedStringWStackTrace("Resource exception occurred in creatingManagedConnection()", (Throwable)((Object)e));
            logger.error((Object)loggerMsg);
        }
    }

    public void setconnectorJndiName(String connectorJndiName) {
        this.setConnectorJndiName(connectorJndiName);
    }

    public String getConnectorJndiName() {
        return this.connectorJndiName;
    }

    private void setJ2SEProperties() {
        if (!this.adapterEnvironment.equals(EMAdapterEnvironment.J2SE)) {
            this.setAdapterEnvironment(EMAdapterEnvironment.J2SE);
        }
        this.connectorEnabled = true;
    }

    void setAlwaysUseDefaultAsMin(boolean value) {
        this.alwaysUseDefaultAsMin = value;
    }

    public boolean isAlwaysUseDefaultAsMin() {
        return this.alwaysUseDefaultAsMin;
    }

    void setDefaultJ2EETimeOut(long timeOut) {
        if (timeOut > 5000L) {
            this.defaultJ2EETimeOut = timeOut;
        } else {
            this.defaultJ2EETimeOut = 5000L;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)this.getLoggerFormattedString("TimeOut configuration attribute value is too short [" + timeOut + "ms]. The following default value is being used instead: " + 5000L + "ms"));
            }
        }
    }

    public long getDefaultJ2EETimeOut() {
        return this.defaultJ2EETimeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementConnectionFailureCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            ++this.connectionFailureCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getConnectionFailureCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            return this.connectionFailureCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementConnectionAuthFailureCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            ++this.connectionAuthFailureCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getConnectionAuthFailureCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            return this.connectionAuthFailureCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementIdentityFailureCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            ++this.identityFailureCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getIdentityFailureCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            return this.identityFailureCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementdivisionMismatchCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            ++this.divisionMismatchCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDivisionMismatchCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            return this.divisionMismatchCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementProductionMismatchCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            ++this.productionMismatchCount;
        }
    }

    protected void setConnectorEnabled(boolean connectorEnabled) {
        this.connectorEnabled = connectorEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getProductionMismatchCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            return this.productionMismatchCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCreateConnectionHandleTime(long elapsedMillis) {
        Object object = this.createConnectionHandleAvgSyncObj;
        synchronized (object) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("elapsedMillis to add: " + Long.toString(elapsedMillis)));
            }
            if (elapsedMillis < Long.MAX_VALUE - this.createConnectionHandleTotalMillis) {
                ++this.createConnectionHandleCount;
                this.createConnectionHandleTotalMillis += elapsedMillis;
            } else {
                logger.error((Object)"CreateConnectionHandle time total exceeded LONG MAX_VALUE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCreateConnectionHandleAvgMillis() {
        Object object = this.createConnectionHandleAvgSyncObj;
        synchronized (object) {
            if (this.createConnectionHandleCount > 0L) {
                return new Long(this.createConnectionHandleTotalMillis).doubleValue() / new Long(this.createConnectionHandleCount).doubleValue();
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMatchManagedConnectionTime(long elapsedMillis) {
        Object object = this.matchManagedConnectionAvgSyncObj;
        synchronized (object) {
            if (elapsedMillis < Long.MAX_VALUE - this.matchManagedConnectionTotalMillis) {
                ++this.matchManagedConnectionCount;
                this.matchManagedConnectionTotalMillis += elapsedMillis;
            } else {
                logger.error((Object)"MatchManagedConnection time total exceeded LONG MAX_VALUE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMatchManagedConnectionAvgMillis() {
        Object object = this.matchManagedConnectionAvgSyncObj;
        synchronized (object) {
            if (this.matchManagedConnectionCount > 0L) {
                return new Long(this.matchManagedConnectionTotalMillis).doubleValue() / new Long(this.matchManagedConnectionCount).doubleValue();
            }
            return 0.0;
        }
    }

    protected String getPrimaryStation() {
        return this.primaryStation;
    }

    protected void setAccessCode(String accessCode) {
        this.accessCode = accessCode;
    }

    protected void setHostIpAddress(String hostIpAddress) {
        this.hostIpAddress = hostIpAddress;
    }

    protected void setHostPort(int hostPort) {
        this.hostPort = hostPort;
    }

    protected void setPrimaryStation(String primaryStation) {
        this.primaryStation = primaryStation;
    }

    protected void setPrimaryStationSuffix(String primaryStationSuffix) {
        this.primaryStationSuffix = primaryStationSuffix;
    }

    protected void setVerifyCode(String verifyCode) {
        this.verifyCode = verifyCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (this.adapterEnvironment == EMAdapterEnvironment.J2EE) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("considering removing mappings for JNDI Name '" + this.connectorJndiName + "', distinguished identifier '" + this.distinguishedIdentifier + "."));
                }
                InstitutionMappingImpl instMap = InstitutionMappingImpl.getInstance();
                instMap.removeMappingsForJndiName(this.connectorJndiName, new String[]{this.primaryStation}, this.distinguishedIdentifier);
            }
            finally {
                super.finalize();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger.info((Object)"Creating managed connection factory, VistALink adapter version 1.5.0.026.");
        ServerType serverType = Environment.getServerType();
        if (serverType.equals(ServerType.WEBLOGIC)) {
            VistaLinkRuntimeInfo.register();
        } else if (serverType.equals(ServerType.UNKNOWN)) {
            logger.warn((Object)"gov.va.med.environment.servertype is not defined for this JVM. For J2EE systems only -- check this -D JVM arg; MBeans required for the VistaLink console will not be loaded.");
        } else if (!serverType.equals(ServerType.JAVA_SE)) {
            logger.warn((Object)("MBeans required for the VistaLink console are not supported for server type " + serverType + " and will not be loaded."));
        }
        if (!InstitutionMappingImpl.instanceExists()) {
            try {
                logger.debug((Object)"Creating institution mapping singleton instance.");
                InstitutionMappingImpl.createInstance();
                if (serverType.equals(ServerType.WEBLOGIC)) {
                    InstitutionMapManager.register();
                }
            }
            catch (VistaLinkResourceException e) {
                logger.error((Object)"Could create institution mapping singleton instance.", (Throwable)((Object)e));
            }
            catch (Exception e) {
                logger.error((Object)"Could create institution mapping singleton instance.", (Throwable)e);
            }
        }
    }
}

