/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.heartbeat;

import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.heartbeat.HeartBeatFailedException;
import gov.va.med.vistalink.adapter.heartbeat.VistaHeartBeatTimerRequest;
import gov.va.med.vistalink.adapter.heartbeat.VistaHeartBeatTimerResponse;
import gov.va.med.vistalink.adapter.heartbeat.VistaHeartBeatTimerResponseFactory;
import gov.va.med.vistalink.adapter.record.VistaLinkFaultException;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseVO;
import gov.va.med.vistalink.adapter.spi.EMAdapterEnvironment;
import gov.va.med.vistalink.adapter.spi.VistaLinkManagedConnection;
import java.util.ArrayList;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class VistaHeartbeatTimerTask
extends TimerTask {
    private ArrayList managedConnections = new ArrayList();
    private long heartBeatRate;
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$vistalink$adapter$heartbeat$VistaHeartbeatTimerTask == null ? (class$gov$va$med$vistalink$adapter$heartbeat$VistaHeartbeatTimerTask = VistaHeartbeatTimerTask.class$("gov.va.med.vistalink.adapter.heartbeat.VistaHeartbeatTimerTask")) : class$gov$va$med$vistalink$adapter$heartbeat$VistaHeartbeatTimerTask));
    private EMAdapterEnvironment adapterEnvironment;
    static /* synthetic */ Class class$gov$va$med$vistalink$adapter$heartbeat$VistaHeartbeatTimerTask;

    public VistaHeartbeatTimerTask(EMAdapterEnvironment adapterEnvironment) {
        this.adapterEnvironment = adapterEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        VistaHeartBeatTimerRequest req;
        Object[] array;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Run");
        }
        ArrayList arrayList = this.managedConnections;
        synchronized (arrayList) {
            array = this.managedConnections.toArray();
        }
        try {
            req = new VistaHeartBeatTimerRequest(this.adapterEnvironment);
        }
        catch (FoundationsException e) {
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = "could not create VistaHeartBeatTimerRequest" + "\n\t" + ExceptionUtils.getFullStackTrace((Throwable)e);
                logger.error((Object)errMsg);
            }
            return;
        }
        VistaHeartBeatTimerResponseFactory resFactory = new VistaHeartBeatTimerResponseFactory();
        for (int i = 0; i < array.length; ++i) {
            String errMsg;
            try {
                VistaLinkManagedConnection mc = (VistaLinkManagedConnection)array[i];
                if (!mc.isValid() || System.currentTimeMillis() - mc.getLastInteractionTimeMillis() <= this.getHeartBeatRate()) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)new StringBuffer().append("sending heartbeat->").append(mc.toString()));
                }
                if (VistaHeartbeatTimerTask.isHeartBeatSuccessful(mc.executeInteraction(req, resFactory))) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)new StringBuffer().append("HeartBeat successful->").append(mc.toString()).append("->").append(System.currentTimeMillis()));
                    continue;
                }
                errMsg = "heartbeat failed->" + mc.toString() + "->" + System.currentTimeMillis();
                HeartBeatFailedException e = new HeartBeatFailedException(errMsg);
                if (logger.isEnabledFor(Priority.ERROR)) {
                    errMsg = "could not execute heart beat" + "\n\t" + ExceptionUtils.getFullStackTrace((Throwable)((Object)e));
                    logger.error((Object)errMsg);
                }
                mc.notifyErrorOccurred((Exception)((Object)e));
                continue;
            }
            catch (VistaLinkFaultException e) {
                if (!logger.isEnabledFor(Priority.ERROR)) continue;
                errMsg = "VistaLinkFaultException occured during heartbeat." + "\n\t" + ExceptionUtils.getFullStackTrace((Throwable)((Object)e));
                logger.error((Object)errMsg);
                continue;
            }
            catch (FoundationsException e) {
                if (!logger.isEnabledFor(Priority.ERROR)) continue;
                errMsg = "FoundationsException occured during heartbeat." + "\n\t" + ExceptionUtils.getFullStackTrace((Throwable)e);
                logger.error((Object)errMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagedConnection(VistaLinkManagedConnection mc) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"adding managed connection");
        }
        ArrayList arrayList = this.managedConnections;
        synchronized (arrayList) {
            this.managedConnections.add(mc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManagedConnection(VistaLinkManagedConnection mc) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"remove managed connection");
        }
        ArrayList arrayList = this.managedConnections;
        synchronized (arrayList) {
            this.managedConnections.remove(mc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isManagedConnectionListEmpty() {
        ArrayList arrayList = this.managedConnections;
        synchronized (arrayList) {
            return this.managedConnections.isEmpty();
        }
    }

    private static boolean isHeartBeatSuccessful(VistaLinkResponseVO res) {
        return ((VistaHeartBeatTimerResponse)res).isHeartBeatSuccessful();
    }

    public long getHeartBeatRate() {
        return this.heartBeatRate;
    }

    public void setHeartBeatRate(long heartBeatRate) {
        this.heartBeatRate = heartBeatRate;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

