/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.spi;

import gov.va.med.crypto.VistaKernelHashCountLimitExceededException;
import gov.va.med.environment.Environment;
import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.net.VistaSocketException;
import gov.va.med.net.VistaSocketTimeOutException;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionMetaData;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionSpecImpl;
import gov.va.med.vistalink.adapter.cci.VistaLinkResourceException;
import gov.va.med.vistalink.adapter.heartbeat.HeartBeatInitializationFailedException;
import gov.va.med.vistalink.adapter.record.VistaLinkFaultException;
import gov.va.med.vistalink.adapter.record.VistaLinkRequestVO;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseFactory;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseFactoryImpl;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseVO;
import gov.va.med.vistalink.adapter.spi.ConnectionHandlesExceededException;
import gov.va.med.vistalink.adapter.spi.EMAdapterEnvironment;
import gov.va.med.vistalink.adapter.spi.EMAdapterStatus;
import gov.va.med.vistalink.adapter.spi.EMReAuthState;
import gov.va.med.vistalink.adapter.spi.VistaLinkConnectionEventNotifier;
import gov.va.med.vistalink.adapter.spi.VistaLinkConnectionImpl;
import gov.va.med.vistalink.adapter.spi.VistaLinkConnectionRequestInfo;
import gov.va.med.vistalink.adapter.spi.VistaLinkInitSocketRequest;
import gov.va.med.vistalink.adapter.spi.VistaLinkInitSocketResponse;
import gov.va.med.vistalink.adapter.spi.VistaLinkInitSocketResponseFactory;
import gov.va.med.vistalink.adapter.spi.VistaLinkJ2SEConnSpec;
import gov.va.med.vistalink.adapter.spi.VistaLinkManagedConnectionFactory;
import gov.va.med.vistalink.adapter.spi.VistaLinkManagedConnectionMetaData;
import gov.va.med.vistalink.adapter.spi.VistaLinkRequestRetryStrategyAllowOverride;
import gov.va.med.vistalink.adapter.spi.VistaLinkSocketAlreadyClosedException;
import gov.va.med.vistalink.adapter.spi.VistaLinkSocketClosedException;
import gov.va.med.vistalink.adapter.spi.VistaLinkSystemInfoRequest;
import gov.va.med.vistalink.adapter.spi.VistaLinkSystemInfoResponse;
import gov.va.med.vistalink.adapter.spi.VistaLinkSystemInfoResponseFactory;
import gov.va.med.vistalink.adapter.spi.VistaSocketConnection;
import gov.va.med.vistalink.rpc.RpcRequest;
import gov.va.med.vistalink.rpc.RpcResponse;
import gov.va.med.vistalink.rpc.RpcResponseFactory;
import gov.va.med.vistalink.security.m.KernelSecurityHandshakeManaged;
import gov.va.med.vistalink.security.m.SecurityDataLogonResponse;
import gov.va.med.vistalink.security.m.SecurityDivisionDeterminationFaultException;
import gov.va.med.vistalink.security.m.SecurityIdentityDeterminationFaultException;
import gov.va.med.vistalink.security.m.SecurityProductionMismatchException;
import gov.va.med.vistalink.security.m.SecurityResponseFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Iterator;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class VistaLinkManagedConnection
implements ManagedConnection {
    private static final int UNLIMITED_CONNECTION_HANDLES = -1;
    private static final String EXCEPTION_CONNECTION_HANDLES_EXCEEDED = "There are no available connection handles.";
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$vistalink$adapter$spi$VistaLinkManagedConnection == null ? (class$gov$va$med$vistalink$adapter$spi$VistaLinkManagedConnection = VistaLinkManagedConnection.class$("gov.va.med.vistalink.adapter.spi.VistaLinkManagedConnection")) : class$gov$va$med$vistalink$adapter$spi$VistaLinkManagedConnection));
    private VistaLinkConnectionEventNotifier connectionEventNotifer;
    private VistaLinkManagedConnectionFactory managedConnectionFactory;
    private PrintWriter logWriter;
    private HashSet conSet;
    private int hashCode;
    private VistaSocketConnection socketCon;
    private boolean valid;
    private boolean destroying;
    private boolean constructing;
    private EMAdapterStatus adapterStatus;
    private long lastTimeRpcExecutedMillis;
    private VistaLinkRequestRetryStrategyAllowOverride allowOverrideStrategy = null;
    private long lastInteractionTimeMillis;
    private VistaLinkConnectionRequestInfo connReqInfo = null;
    EMReAuthState reAuthState;
    private long distinguishedIdentifier;
    private long heartBeatRate = 0L;
    private static final String INITIAL_M_JOB_VALUE = "[Not Set]";
    private static final String RESETTING_M_JOB_VALUE = "[Resetting...]";
    private String mJob = "[Not Set]";
    private long reAuthSessionTimeout;
    private long socketTimeOut = 5000L;
    static /* synthetic */ Class class$gov$va$med$vistalink$adapter$spi$VistaLinkManagedConnection;

    protected VistaLinkManagedConnection(VistaLinkManagedConnectionFactory mcf, long distinguishedIdentifier) throws VistaLinkResourceException {
        this.setManagedConnectionFactory(mcf);
        this.distinguishedIdentifier = distinguishedIdentifier;
        this.setHashCode();
        this.setDefaultSocketTimeOut();
        if (logger.isDebugEnabled()) {
            String debugMsg = this.getLoggerFormattedString("Constructing");
            logger.debug((Object)debugMsg);
        }
        this.conSet = new HashSet();
        this.allowOverrideStrategy = new VistaLinkRequestRetryStrategyAllowOverride(this);
        this.connectionEventNotifer = new VistaLinkConnectionEventNotifier();
        try {
            this.createAuthenticatedConnection();
        }
        catch (VistaLinkResourceException e) {
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = this.getLoggerFormattedStringWStackTrace((Throwable)((Object)e));
                logger.error((Object)errMsg);
            }
            this.setValid(false);
            try {
                if (this.socketCon != null) {
                    if (logger.isEnabledFor(Priority.ERROR)) {
                        String errorMsg = this.getLoggerFormattedString("Attempting to close socket that should already be closed, check implementation");
                        logger.error((Object)errorMsg);
                    }
                    this.socketCon.close();
                }
            }
            catch (VistaSocketException socex) {
                throw new VistaLinkResourceException("could not close managed connection, check the implementation", (Exception)((Object)new VistaLinkResourceException(ExceptionUtils.getFullStackTrace((Throwable)socex), (Exception)((Object)e))));
            }
            finally {
                this.socketCon = null;
            }
            throw e;
        }
        try {
            this.addToTimerTask();
        }
        catch (VistaLinkResourceException e1) {
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = this.getLoggerFormattedStringWStackTrace((Throwable)((Object)e1));
                logger.error((Object)errMsg);
            }
            try {
                this.destroy();
            }
            catch (ResourceException e2) {
                throw new VistaLinkResourceException("could not destroy managed connection", (Exception)((Object)new VistaLinkResourceException(ExceptionUtils.getFullStackTrace((Throwable)e2), (Exception)((Object)e1))));
            }
            throw e1;
        }
        this.setReAuthState(EMReAuthState.VIRGIN);
        this.adapterStatus = EMAdapterStatus.RUNNING;
    }

    private void executeInitSocketInteraction() throws VistaLinkResourceException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)this.getLoggerFormattedString("Executing Init Socket interaction"));
            }
            VistaLinkInitSocketRequest req = new VistaLinkInitSocketRequest(this.getAdapterEnvironment());
            VistaLinkInitSocketResponseFactory resFac = new VistaLinkInitSocketResponseFactory();
            VistaLinkInitSocketResponse resp = (VistaLinkInitSocketResponse)this.executeInteraction(req, resFac);
            this.setHeartBeatRate(resp.getHeartBeatRateMillis());
            this.setMJob(resp.getMJob());
            this.setReAuthSessionTimeout(resp.getReAuthSessionTimeout());
        }
        catch (VistaLinkFaultException e) {
            throw new VistaLinkResourceException("VistaLinkFaultException in executeInitSocketInteraction.", (Exception)((Object)e));
        }
        catch (FoundationsException e) {
            throw new VistaLinkResourceException("FoundationsException in executeInitSocketInteraction.", (Exception)((Object)e));
        }
    }

    private void createAuthenticatedConnection() throws VistaLinkResourceException {
        block19: {
            this.adapterStatus = EMAdapterStatus.CONSTRUCTING;
            this.socketCon = null;
            try {
                this.socketCon = new VistaSocketConnection(this.getHostAddr(), this.getHostPort(), this.toString());
            }
            catch (VistaSocketException e) {
                String errStr = "Can not create VistaSocketConnection";
                if (logger.isEnabledFor(Priority.ERROR)) {
                    String errMsg = this.getLoggerFormattedStringWStackTrace(errStr, e);
                    logger.error((Object)errMsg);
                }
                logger.debug((Object)"about to increment connection failure count due to no path to listener.");
                if (this.getAdapterEnvironment() != null && this.getAdapterEnvironment().equals(EMAdapterEnvironment.J2EE)) {
                    this.managedConnectionFactory.incrementConnectionFailureCount();
                }
                throw new VistaLinkResourceException(errStr, (Exception)((Object)e));
            }
            this.setValid(true);
            try {
                try {
                    if (this.getAdapterEnvironment() != null) {
                        this.executeInitSocketInteraction();
                        if (this.getAdapterEnvironment().equals(EMAdapterEnvironment.J2EE)) {
                            this.performInitialAuthenticationSetup();
                            this.performInitialAuthenticationLogon(this.getAccessCode(), this.getVerifyCode(), false);
                        }
                        break block19;
                    }
                    String errMsg = "The adapter environment is null, cannot determine if initial authentication is needed. ";
                    if (logger.isEnabledFor(Priority.ERROR)) {
                        errMsg = this.getLoggerFormattedString(errMsg);
                        logger.error((Object)errMsg);
                    }
                    throw new VistaLinkResourceException(errMsg);
                }
                catch (VistaLinkResourceException e) {
                    if (this.getAdapterEnvironment() != null && this.getAdapterEnvironment().equals(EMAdapterEnvironment.J2EE) && (e.getLinkedException() == null || !(e.getLinkedException() instanceof SecurityProductionMismatchException))) {
                        this.managedConnectionFactory.incrementConnectionAuthFailureCount();
                    }
                    if (logger.isEnabledFor(Priority.ERROR)) {
                        String errMsg = this.getLoggerFormattedStringWStackTrace((Throwable)((Object)e));
                        logger.error((Object)errMsg);
                    }
                    throw e;
                }
            }
            catch (VistaLinkResourceException e) {
                try {
                    if (this.socketCon != null) {
                        this.socketCon.close();
                    }
                }
                catch (VistaSocketException socex) {
                    throw new VistaLinkResourceException("could not close managed connection", (Exception)((Object)new VistaLinkResourceException(ExceptionUtils.getFullStackTrace((Throwable)socex), (Exception)((Object)e))));
                }
                finally {
                    this.socketCon = null;
                }
                throw e;
            }
        }
        this.adapterStatus = EMAdapterStatus.RUNNING;
    }

    private void performInitialAuthenticationSetup() throws VistaLinkResourceException {
        try {
            if (logger.isDebugEnabled()) {
                String debugMsg = this.getLoggerFormattedString("Setting up authentication");
                logger.debug((Object)debugMsg);
            }
            KernelSecurityHandshakeManaged.doSetupAndGetIntroText(this, new SecurityResponseFactory(), true, new Boolean(Environment.isProduction()), this.managedConnectionFactory.getPrimaryStation());
        }
        catch (SecurityProductionMismatchException e) {
            if (this.getAdapterEnvironment() != null && this.getAdapterEnvironment().equals(EMAdapterEnvironment.J2EE)) {
                this.managedConnectionFactory.incrementProductionMismatchCount();
            }
            throw new VistaLinkResourceException("Can not perform setup", (Exception)((Object)e));
        }
        catch (VistaLinkFaultException e) {
            String errStr = "Can not perform setup";
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = this.getLoggerFormattedStringWStackTrace(errStr, (Throwable)((Object)e));
                logger.error((Object)errMsg);
            }
            throw new VistaLinkResourceException(errStr, (Exception)((Object)e));
        }
        catch (ParserConfigurationException e) {
            String errStr = "Can not perform setup";
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = this.getLoggerFormattedStringWStackTrace(errStr, e);
                logger.error((Object)errMsg);
            }
            throw new VistaLinkResourceException(errStr, e);
        }
        catch (FoundationsException e) {
            String errStr = "Can not perform setup";
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = this.getLoggerFormattedStringWStackTrace(errStr, e);
                logger.error((Object)errMsg);
            }
            throw new VistaLinkResourceException(errStr, (Exception)((Object)e));
        }
    }

    private void performInitialAuthenticationLogon(String accessCode, String verifyCode, boolean requestCvc) throws VistaLinkResourceException {
        try {
            SecurityDataLogonResponse responseData;
            if (logger.isDebugEnabled()) {
                String debugMsg = this.getLoggerFormattedString("executing first phase logon");
                logger.debug((Object)debugMsg);
            }
            if ((responseData = KernelSecurityHandshakeManaged.doAVLogon(this, new SecurityResponseFactory(), accessCode, verifyCode, requestCvc)).getResultType() == 2) {
                if (responseData.getSecurityVOLogon().getNeedNewVerifyCode()) {
                    String errStr = "Need new Verify Code: " + responseData.getSecurityVOLogon().getNeedNewVerifyCode() + " Need to select Divisions: " + responseData.getSecurityVOLogon().getNeedDivisionSelection();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)this.getLoggerFormattedString(errStr));
                    }
                    throw new VistaLinkResourceException(errStr);
                }
                if (responseData.getSecurityVOLogon().getNeedDivisionSelection()) {
                    String errStr = "Need new Verify Code: " + responseData.getSecurityVOLogon().getNeedNewVerifyCode() + " Need to select Divisions: " + responseData.getSecurityVOLogon().getNeedDivisionSelection();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)this.getLoggerFormattedString(errStr));
                    }
                    throw new VistaLinkResourceException(errStr);
                }
                throw new VistaLinkResourceException("Logon response was partial success, but M provided no reason for why login is only a partial success!");
            }
            if (responseData.getResultType() == 1) {
                this.setReAuthState(EMReAuthState.NOTAUTHENTICATED);
                return;
            }
            throw new VistaLinkResourceException("Could not perform logon[]" + responseData.getResultMessage());
        }
        catch (VistaKernelHashCountLimitExceededException e) {
            String errStr = "Could not perform Logon";
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = this.getLoggerFormattedStringWStackTrace(errStr, e);
                logger.error((Object)errMsg);
            }
            throw new VistaLinkResourceException(errStr, (Exception)((Object)e));
        }
        catch (ParserConfigurationException e) {
            String errStr = "Could not perform Logon";
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = this.getLoggerFormattedStringWStackTrace(errStr, e);
                logger.error((Object)errMsg);
            }
            throw new VistaLinkResourceException(errStr, e);
        }
        catch (FoundationsException e) {
            String errStr = "Could not perform Logon";
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = this.getLoggerFormattedStringWStackTrace(errStr, e);
                logger.error((Object)errMsg);
            }
            throw new VistaLinkResourceException(errStr, (Exception)((Object)e));
        }
    }

    private boolean performLogout() throws VistaLinkResourceException {
        try {
            if (logger.isDebugEnabled()) {
                String debugMsg = this.getLoggerFormattedString("Executing logout");
                logger.debug((Object)debugMsg);
            }
            KernelSecurityHandshakeManaged.doLogout(this, new SecurityResponseFactory());
        }
        catch (VistaLinkSocketAlreadyClosedException e) {
            if (logger.isEnabledFor(Priority.DEBUG)) {
                String loggerMsg = this.getLoggerFormattedString("This socket is already closed, no need to logout");
                logger.debug((Object)loggerMsg);
            }
            return false;
        }
        catch (VistaLinkFaultException e) {
            String errStr = "Could not perform Logout";
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = this.getLoggerFormattedStringWStackTrace(errStr, (Throwable)((Object)e));
                logger.error((Object)errMsg);
            }
            throw new VistaLinkResourceException(errStr, (Exception)((Object)e));
        }
        catch (ParserConfigurationException e) {
            String errStr = "Could not perform Logout";
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = this.getLoggerFormattedStringWStackTrace(errStr, e);
                logger.error((Object)errMsg);
            }
            throw new VistaLinkResourceException(errStr, e);
        }
        catch (FoundationsException e) {
            String errStr = "Could not perform Logout";
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = this.getLoggerFormattedStringWStackTrace(errStr, e);
                logger.error((Object)errMsg);
            }
            throw new VistaLinkResourceException(errStr, (Exception)((Object)e));
        }
        catch (ResourceException e) {
            String errStr = "Could not perform Logout";
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = this.getLoggerFormattedStringWStackTrace(errStr, e);
                logger.error((Object)errMsg);
            }
            throw new VistaLinkResourceException(errStr, (Exception)((Object)e));
        }
        catch (IOException e) {
            String errStr = "Could not perform Logout";
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = this.getLoggerFormattedStringWStackTrace(errStr, e);
                logger.error((Object)errMsg);
            }
            throw new VistaLinkResourceException(errStr, e);
        }
        return true;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (logger.isDebugEnabled()) {
            String debugMsg = this.getLoggerFormattedString("addConnectionEventListener");
            logger.debug((Object)debugMsg);
        }
        this.connectionEventNotifer.addConnectorListener(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (logger.isDebugEnabled()) {
            String debugMsg = this.getLoggerFormattedString("removeConnectionEventListener");
            logger.debug((Object)debugMsg);
        }
        this.connectionEventNotifer.removeConnectorListener(listener);
    }

    protected boolean isConnectionHandleAvailable() {
        if (this.getMaxConnectionHandles() == -1) {
            return true;
        }
        return this.conSet.size() < this.getMaxConnectionHandles();
    }

    private void addConHandle(VistaLinkConnection con) throws ConnectionHandlesExceededException {
        if (logger.isDebugEnabled()) {
            String debugMsg = this.getLoggerFormattedString("addConHandle");
            logger.debug((Object)debugMsg);
        }
        if (!this.isConnectionHandleAvailable()) {
            String errStr = EXCEPTION_CONNECTION_HANDLES_EXCEEDED + "[" + this.getMaxConnectionHandles() + "]";
            throw new ConnectionHandlesExceededException(errStr);
        }
        this.conSet.add(con);
    }

    private synchronized void removeConHandle(VistaLinkConnection con) {
        if (logger.isDebugEnabled()) {
            String debugMsg = this.getLoggerFormattedString("removeConHandle");
            logger.debug((Object)debugMsg);
        }
        this.conSet.remove(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateConnection(Object connection) throws ResourceException {
        try {
            Object errStr;
            if (logger.isDebugEnabled()) {
                String debugMsg = this.getLoggerFormattedString("associateConnection");
                logger.debug((Object)debugMsg);
            }
            if (!(connection instanceof VistaLinkConnection)) {
                errStr = "This connection is not of type VistaLinkConnection";
                throw new VistaLinkResourceException((String)errStr);
            }
            errStr = this;
            synchronized (errStr) {
                if (!this.isConnectionHandleAvailable()) {
                    String errStr2 = EXCEPTION_CONNECTION_HANDLES_EXCEEDED + "[" + this.getMaxConnectionHandles() + "]";
                    throw new ConnectionHandlesExceededException(errStr2);
                }
                VistaLinkConnectionImpl con = (VistaLinkConnectionImpl)connection;
                VistaLinkManagedConnection mc = null;
                try {
                    mc = con.getManagedConnection();
                }
                catch (FoundationsException e) {
                    if (logger.isEnabledFor(Priority.ERROR)) {
                        String errMsg = this.getLoggerFormattedStringWStackTrace("The managed connection is null and cannot be disassociated, but the operation will continue", e);
                        logger.error((Object)errMsg);
                    }
                    mc = null;
                }
                if (mc != null) {
                    mc.disassociateConnection(con);
                }
                con.setManagedConnection(this);
                this.addConHandle(con);
            }
        }
        catch (VistaLinkResourceException e) {
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = this.getLoggerFormattedStringWStackTrace("Error associating connection handle", (Throwable)((Object)e));
                logger.error((Object)errMsg);
            }
            throw e;
        }
    }

    public void disassociateConnection(VistaLinkConnectionImpl con) {
        if (logger.isDebugEnabled()) {
            String debugMsg = this.getLoggerFormattedString("disassociate connection");
            logger.debug((Object)debugMsg);
        }
        con.setManagedConnection(null);
        this.removeConHandle(con);
    }

    public void cleanup() throws ResourceException {
        if (logger.isDebugEnabled()) {
            String debugMsg = this.getLoggerFormattedString("Managed connection cleanup");
            logger.debug((Object)debugMsg);
        }
        Iterator it = this.conSet.iterator();
        while (it.hasNext()) {
            VistaLinkConnectionImpl con = (VistaLinkConnectionImpl)it.next();
            this.removeConHandle(con);
            con.setManagedConnection(null);
        }
    }

    public synchronized void destroy() throws ResourceException {
        if (logger.isDebugEnabled()) {
            String debugMsg = this.getLoggerFormattedString("Destroying managed connection");
            logger.debug((Object)debugMsg);
        }
        this.adapterStatus = EMAdapterStatus.DESTROYING;
        this.removeFromTimerTask();
        try {
            block8: {
                try {
                    boolean sendCloseRequest = this.performLogout();
                    this.socketCon.close(sendCloseRequest);
                    if (!logger.isDebugEnabled()) break block8;
                    String debugMsg = this.getLoggerFormattedString("Socket has been successfully closed");
                    logger.debug((Object)debugMsg);
                }
                catch (VistaSocketException sockExc) {
                    String errMsg = this.getLoggerFormattedStringWStackTrace("Can not close VistaSocketConnection.", sockExc);
                    if (logger.isEnabledFor(Priority.ERROR)) {
                        logger.error((Object)errMsg);
                    }
                    throw new VistaLinkResourceException(errMsg, (Exception)((Object)sockExc));
                }
                catch (VistaLinkResourceException e) {
                    if (logger.isEnabledFor(Priority.ERROR)) {
                        String errMsg = this.getLoggerFormattedStringWStackTrace("Can not perform destroy on managed connection", (Throwable)((Object)e));
                        logger.error((Object)errMsg);
                    }
                    throw e;
                }
            }
            Object var4_8 = null;
            this.setValid(false);
            this.socketCon = null;
            this.connReqInfo = null;
            this.setReAuthState(EMReAuthState.NOTAUTHENTICATED);
            this.managedConnectionFactory.removeMc(this);
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            this.setValid(false);
            this.socketCon = null;
            this.connReqInfo = null;
            this.setReAuthState(EMReAuthState.NOTAUTHENTICATED);
            this.managedConnectionFactory.removeMc(this);
            throw throwable;
        }
    }

    public void closeHandle(VistaLinkConnection con) throws ResourceException {
        if (logger.isDebugEnabled()) {
            String debugMsg = this.getLoggerFormattedString("Closing handle");
            logger.debug((Object)debugMsg);
        }
        this.removeConHandle(con);
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle((Object)con);
        this.connectionEventNotifer.connectionClosed(event);
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connReqInfo) throws ConnectionHandlesExceededException, ResourceException {
        try {
            String debugMsg;
            long beginTimeMillis = System.currentTimeMillis();
            VistaLinkConnectionImpl con = null;
            VistaLinkConnectionRequestInfo cri = null;
            if (logger.isDebugEnabled()) {
                debugMsg = this.getLoggerFormattedString("Getting connection handle");
                logger.debug((Object)debugMsg);
            }
            VistaLinkManagedConnection vistaLinkManagedConnection = this;
            synchronized (vistaLinkManagedConnection) {
                if (this.isConnectionHandleAvailable()) {
                    if (logger.isDebugEnabled()) {
                        debugMsg = this.getLoggerFormattedString("Connection handle available");
                        logger.debug((Object)debugMsg);
                    }
                    con = new VistaLinkConnectionImpl(this);
                    cri = (VistaLinkConnectionRequestInfo)connReqInfo;
                    if (this.connReqInfo == null || !this.connReqInfo.equals(cri)) {
                        this.setReAuthState(EMReAuthState.NOTAUTHENTICATED);
                    } else if (this.idleTimeCheck()) {
                        this.setReAuthState(EMReAuthState.NOTAUTHENTICATED);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)this.getLoggerFormattedString("Connection re-authentication status: '" + this.reAuthState.toString() + "'. cri = " + this.getConnReqInfoString().toString()));
                    }
                    this.connReqInfo = cri;
                    this.addConHandle(con);
                    long elapsedTimeMillis = System.currentTimeMillis() - beginTimeMillis;
                    this.managedConnectionFactory.addCreateConnectionHandleTime(elapsedTimeMillis);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)this.getLoggerFormattedString("getConnection(...) processing time = " + elapsedTimeMillis));
                    }
                    return con;
                }
                String errStr = EXCEPTION_CONNECTION_HANDLES_EXCEEDED + "[" + this.getMaxConnectionHandles() + "]";
                throw new ConnectionHandlesExceededException(errStr);
            }
        }
        catch (VistaLinkResourceException e) {
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = this.getLoggerFormattedStringWStackTrace("Error getting connection", (Throwable)((Object)e));
                logger.error((Object)errMsg);
            }
            throw e;
        }
    }

    private boolean idleTimeCheck() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTimeRpcExecutedMillis > this.reAuthSessionTimeout) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)this.getLoggerFormattedString("Managed connection was idle too long. Re-authentication is required.\n\tCurrent Time: \t" + currentTime + "\n\tLast RPC Execution Time: \t" + this.lastTimeRpcExecutedMillis + "\n\tDifference: \t" + (currentTime - this.lastTimeRpcExecutedMillis) + "\n\tRefresh Rate: \t" + this.reAuthSessionTimeout));
            }
            return true;
        }
        return false;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException("Transaction Not Supported!");
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new VistaLinkManagedConnectionMetaData(this);
    }

    public ConnectionMetaData getConnectionMetaData() throws ResourceException {
        VistaLinkConnectionMetaData ret = new VistaLinkConnectionMetaData(this);
        return ret;
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException("Distributed Transaction Not Supported!");
    }

    private void setManagedConnectionFactory(VistaLinkManagedConnectionFactory mcf) {
        this.managedConnectionFactory = mcf;
    }

    protected VistaLinkManagedConnectionFactory getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    public void setLogWriter(PrintWriter wr) throws ResourceException {
        this.logWriter = wr;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public int getMaxConnectionHandles() {
        return this.getManagedConnectionFactory().getMaxConnectionHandles();
    }

    public InetAddress getHostAddr() {
        return this.getManagedConnectionFactory().getHostIpAddressResolved();
    }

    public int getHostPort() {
        return this.getManagedConnectionFactory().getHostPort();
    }

    private long getFactoryDistinguishedIdentifier() {
        return this.getManagedConnectionFactory().getDistinguishedIdentifier();
    }

    public RpcResponse executeRPC(RpcRequest request) throws VistaLinkFaultException, FoundationsException {
        VistaLinkConnectionSpecImpl connSpec = null;
        RpcResponse response = null;
        if (this.getAdapterEnvironment().equals(EMAdapterEnvironment.J2EE)) {
            connSpec = (VistaLinkConnectionSpecImpl)this.connReqInfo.getConnectionSpec();
            if (connSpec == null) {
                throw new FoundationsException("The adapter environment is [" + this.getAdapterEnvironment().toString() + "] and the connection spec is null.");
            }
            if (logger.isDebugEnabled()) {
                StringBuffer debugMsg = new StringBuffer("About to execute RPC: '");
                debugMsg.append(request.getRpcName());
                debugMsg.append("', on connector configured with JNDI name: '");
                debugMsg.append(this.managedConnectionFactory.getConnectorJndiName());
                debugMsg.append("', primaryStation: '");
                debugMsg.append(this.managedConnectionFactory.getPrimaryStation());
                debugMsg.append("', reauthentication type: '");
                debugMsg.append(connSpec.getSecurityType());
                debugMsg.append("', credentials: '");
                Iterator specValuesIter = connSpec.getProprietarySecurityInfo().iterator();
                while (specValuesIter.hasNext()) {
                    debugMsg.append((String)specValuesIter.next());
                    debugMsg.append(specValuesIter.hasNext() ? ", " : "'.");
                }
                logger.debug((Object)debugMsg.toString());
            }
        } else {
            connSpec = new VistaLinkJ2SEConnSpec();
            this.setReAuthState(EMReAuthState.AUTHENTICATED);
        }
        request.setReAuthenticateInfo(connSpec, this.reAuthState, this.getAdapterEnvironment());
        response = (RpcResponse)this.executeInteraction(request, new RpcResponseFactory());
        if (this.getAdapterEnvironment().equals(EMAdapterEnvironment.J2EE)) {
            this.setReAuthState(EMReAuthState.AUTHENTICATED);
            this.lastTimeRpcExecutedMillis = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Completed execution of RPC: " + request.getRpcName()));
            }
        }
        return response;
    }

    public VistaLinkResponseVO executeInteraction(VistaLinkRequestVO requestVO, VistaLinkResponseFactory responseFactory) throws VistaLinkFaultException, FoundationsException {
        VistaLinkResponseVO responseVO;
        block27: {
            responseVO = null;
            long savedSocketTimeOut = this.socketTimeOut;
            if (requestVO.getTimeOut() > 0) {
                this.setSocketTimeOut(requestVO.getTimeOut());
            }
            if (logger.isDebugEnabled()) {
                String debugMsg = this.getLoggerFormattedString("Executing interaction");
                logger.debug((Object)debugMsg);
            }
            try {
                String responseStr;
                try {
                    responseStr = this.getResponseFromSocket(requestVO.getRequestString());
                    responseVO = responseFactory.handleResponse(responseStr, requestVO);
                }
                catch (VistaSocketTimeOutException stoe) {
                    this.restoreAuthenticatedConnection(stoe);
                }
                catch (VistaSocketException se) {
                    if (this.doRetryStrategies(requestVO)) {
                        this.restoreAuthenticatedConnection(se);
                        responseStr = this.doRetry(requestVO);
                        responseVO = responseFactory.handleResponse(responseStr, requestVO);
                        break block27;
                    }
                    throw se;
                }
                catch (SecurityDivisionDeterminationFaultException e) {
                    if (this.getAdapterEnvironment() != null && this.getAdapterEnvironment().equals(EMAdapterEnvironment.J2EE)) {
                        this.managedConnectionFactory.incrementdivisionMismatchCount();
                    }
                    throw e;
                }
                catch (SecurityIdentityDeterminationFaultException e) {
                    if (this.getAdapterEnvironment() != null && this.getAdapterEnvironment().equals(EMAdapterEnvironment.J2EE)) {
                        this.managedConnectionFactory.incrementIdentityFailureCount();
                    }
                    throw e;
                }
            }
            catch (VistaLinkSocketAlreadyClosedException e) {
                throw e;
            }
            catch (VistaLinkFaultException e) {
                throw e;
            }
            catch (VistaSocketTimeOutException e) {
                String msgStr = "Socket timeout has occurred";
                if (this.getAdapterEnvironment().equals(EMAdapterEnvironment.J2EE)) {
                    if (logger.isEnabledFor(Priority.DEBUG)) {
                        String debugMsg = this.getLoggerFormattedStringWStackTrace(msgStr, e);
                        logger.debug((Object)debugMsg);
                    }
                } else {
                    this.removeFromTimerTask();
                    this.notifyErrorOccurred((Exception)((Object)e));
                    if (logger.isEnabledFor(Priority.ERROR)) {
                        String errMsg = this.getLoggerFormattedStringWStackTrace(msgStr, e);
                        logger.error((Object)errMsg);
                    }
                }
                throw new FoundationsException(msgStr, (Throwable)e);
            }
            catch (VistaSocketException e) {
                this.removeFromTimerTask();
                this.notifyErrorOccurred((Exception)((Object)e));
                String errStr = "Exception occurred executing transfer, destroying connection";
                if (logger.isEnabledFor(Priority.ERROR)) {
                    String errMsg = this.getLoggerFormattedStringWStackTrace(errStr, e);
                    logger.error((Object)errMsg);
                }
                throw new FoundationsException(errStr, (Throwable)e);
            }
            catch (VistaLinkSocketClosedException e) {
                String errStr = "Error executing the interaction";
                if (logger.isEnabledFor(Priority.ERROR)) {
                    String errMsg = this.getLoggerFormattedStringWStackTrace(errStr, (Throwable)((Object)e));
                    logger.error((Object)errMsg);
                }
                throw new FoundationsException(errStr, (Throwable)((Object)e));
            }
            catch (FoundationsException e) {
                if (logger.isEnabledFor(Priority.ERROR)) {
                    String errMsg = this.getLoggerFormattedStringWStackTrace("Can not send/receive data from socket (executeInteraction)", e);
                    logger.error((Object)errMsg);
                }
                throw e;
            }
            finally {
                this.setSocketTimeOut(savedSocketTimeOut);
            }
        }
        return responseVO;
    }

    private boolean doRetryStrategies(VistaLinkRequestVO requestVO) {
        String logMsg = "";
        if (this.getAdapterEnvironment().equals(EMAdapterEnvironment.J2SE)) {
            logMsg = "Request retry not attempted because the current environment is J2SE.";
            logger.debug((Object)this.getLoggerFormattedString(logMsg));
            return false;
        }
        if (this.allowOverrideStrategy.execute(requestVO)) {
            logMsg = "Override retry strategy indicates a retry should automatically be attempted and there is no need to execute the request retry strategy";
            logger.debug((Object)this.getLoggerFormattedString(logMsg));
        } else {
            logMsg = "Override retry strategy indicates request retry strategy should be executed";
            logger.debug((Object)this.getLoggerFormattedString(logMsg));
            if (!requestVO.getRetryStrategy().execute(requestVO)) {
                logMsg = "Request retry strategy indicates that an attempt to restore socket should not be performed.";
                logger.debug((Object)this.getLoggerFormattedString(logMsg));
                return false;
            }
        }
        return true;
    }

    private String doRetry(VistaLinkRequestVO requestVO) throws FoundationsException, VistaSocketTimeOutException, VistaLinkSocketClosedException, VistaSocketException {
        String responseStr = "";
        try {
            this.doRetryPreparation(requestVO);
            responseStr = this.getResponseFromSocket(requestVO.getRequestString());
            logger.debug((Object)this.getLoggerFormattedString("Retry restored socket and successfully executed request."));
        }
        catch (VistaSocketTimeOutException stoe) {
            this.restoreAuthenticatedConnection(stoe);
            throw stoe;
        }
        return responseStr;
    }

    private void doRetryPreparation(VistaLinkRequestVO requestVO) {
        if (requestVO instanceof RpcRequest) {
            RpcRequest rpcRequst = (RpcRequest)requestVO;
            VistaLinkConnectionSpecImpl connSpec = (VistaLinkConnectionSpecImpl)this.connReqInfo.getConnectionSpec();
            this.setReAuthState(EMReAuthState.NOTAUTHENTICATED);
            rpcRequst.setReAuthenticateInfo(connSpec, this.reAuthState, this.getAdapterEnvironment());
            logger.debug((Object)this.getLoggerFormattedString("Reset reauthentication information for retry and reauthentication on M/VistA server."));
        }
    }

    private void restoreAuthenticatedConnection(VistaSocketTimeOutException stoe) throws VistaSocketTimeOutException, VistaSocketException {
        this.setReAuthState(EMReAuthState.NOTAUTHENTICATED);
        if (logger.isEnabledFor(Priority.DEBUG)) {
            logger.debug((Object)this.getLoggerFormattedString(stoe.getMessage()));
        }
        if (this.getAdapterEnvironment().equals(EMAdapterEnvironment.J2SE)) {
            throw stoe;
        }
        try {
            this.socketCon.close();
            this.socketCon = null;
            if (this.adapterStatus.equals(EMAdapterStatus.CONSTRUCTING) && this.getMJob().equals(RESETTING_M_JOB_VALUE)) {
                logger.error((Object)this.getLoggerFormattedString("restoreAuthenticatedConnection loop occurrred; exception re-thrown"));
                throw stoe;
            }
            this.setMJob(RESETTING_M_JOB_VALUE);
            this.createAuthenticatedConnection();
        }
        catch (VistaLinkResourceException re) {
            String errStr = "Error getting new authenticated socket connection after socket time out";
            re.setLinkedException((Exception)((Object)stoe));
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = this.getLoggerFormattedStringWStackTrace(errStr, (Throwable)((Object)re));
                logger.error((Object)errMsg);
            }
            throw new VistaSocketException(errStr, (Exception)((Object)re));
        }
        throw stoe;
    }

    private void restoreAuthenticatedConnection(VistaSocketException e) throws VistaSocketException, FoundationsException, VistaLinkSocketAlreadyClosedException, VistaLinkSocketClosedException {
        this.setReAuthState(EMReAuthState.NOTAUTHENTICATED);
        if (this.getAdapterEnvironment().equals(EMAdapterEnvironment.J2SE)) {
            throw e;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.getLoggerFormattedString("Exception[adapterStatus]" + this.adapterStatus.toString()));
        }
        if (this.adapterStatus.equals(EMAdapterStatus.CLEANUP)) {
            String errMsg = "M has most likely terminated this connection, no need to cleanup";
            if (logger.isDebugEnabled()) {
                String loggerMsg = this.getLoggerFormattedString(errMsg);
                logger.debug((Object)loggerMsg);
            }
            throw new VistaLinkSocketAlreadyClosedException(errMsg, (Exception)((Object)e));
        }
        if (this.adapterStatus.equals(EMAdapterStatus.DESTROYING)) {
            String errMsg = "M has most likely terminated this connection, no need to send logout";
            if (logger.isDebugEnabled()) {
                String loggerMsg = this.getLoggerFormattedString(errMsg);
                logger.debug((Object)loggerMsg);
            }
            throw new VistaLinkSocketAlreadyClosedException(errMsg, (Exception)((Object)e));
        }
        if (this.adapterStatus.equals(EMAdapterStatus.CONSTRUCTING)) {
            String errMsg = "This connection cannot be retried because construction has failed";
            if (logger.isEnabledFor(Priority.ERROR)) {
                String loggerMsg = this.getLoggerFormattedStringWStackTrace(errMsg, e);
                logger.error((Object)loggerMsg);
            }
            throw new VistaLinkSocketClosedException(errMsg, (Exception)((Object)e));
        }
        if (logger.isDebugEnabled()) {
            String debugMsg = this.getLoggerFormattedStringWStackTrace("Exception occurred executing transfer, now attempting 2nd pass", e);
            logger.debug((Object)debugMsg);
        }
        this.socketCon.closeDontNotify();
        this.socketCon = null;
        try {
            this.setMJob(RESETTING_M_JOB_VALUE);
            this.createAuthenticatedConnection();
        }
        catch (VistaLinkResourceException e1) {
            String errStr = "Error getting new authenticated socket connection for 2nd pass attempt";
            e1.setLinkedException((Exception)((Object)e));
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = this.getLoggerFormattedStringWStackTrace(errStr, (Throwable)((Object)e1));
                logger.error((Object)errMsg);
            }
            throw new VistaSocketException(errStr, (Exception)((Object)e1));
        }
    }

    public VistaLinkResponseVO executeSystemInteraction(VistaLinkRequestVO requestVO) throws VistaLinkFaultException, FoundationsException {
        return this.executeInteraction(requestVO, new VistaLinkResponseFactoryImpl());
    }

    protected VistaLinkSystemInfoResponse executeSystemInfoInteraction() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)this.getLoggerFormattedString("Executing system info interaction"));
            }
            VistaLinkSystemInfoRequest req = new VistaLinkSystemInfoRequest(this.getAdapterEnvironment());
            VistaLinkSystemInfoResponseFactory resFactory = new VistaLinkSystemInfoResponseFactory();
            VistaLinkSystemInfoResponse resp = (VistaLinkSystemInfoResponse)this.executeInteraction(req, resFactory);
            return resp;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    private synchronized String getResponseFromSocket(String request) throws VistaLinkSocketClosedException, VistaSocketException {
        if (this.socketCon != null && this.isValid()) {
            if (logger.isDebugEnabled()) {
                String debugMsg = this.getLoggerFormattedString("Executing transfer with time out of " + this.socketTimeOut);
                logger.debug((Object)debugMsg);
            }
            this.socketCon.setTransferTimeOut(new Long(this.socketTimeOut).intValue());
            String responseStr = this.socketCon.transfer(request);
            this.setLastInteractionTimeMillis(System.currentTimeMillis());
            return responseStr;
        }
        this.removeFromTimerTask();
        VistaLinkSocketClosedException e = new VistaLinkSocketClosedException("This managed connection is closed. ");
        if (logger.isEnabledFor(Priority.ERROR)) {
            String errMsg = this.getLoggerFormattedString("Error accessing socket");
            logger.error((Object)errMsg, (Throwable)((Object)e));
        }
        throw e;
    }

    public void notifyErrorOccurred(Exception e) {
        if (this.adapterStatus.equals(EMAdapterStatus.DESTROYING)) {
            if (logger.isDebugEnabled()) {
                String debugMsg = this.getLoggerFormattedString("Error occurred while destroying managed connection, will not notify event listeners as they are already notified");
                logger.debug((Object)debugMsg);
            }
            return;
        }
        if (logger.isEnabledFor(Priority.ERROR)) {
            String errMsg = this.getLoggerFormattedStringWStackTrace("Fatal Error has occurred, notifying event listeners", e);
            logger.error((Object)errMsg);
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, e);
        this.connectionEventNotifer.connectionErrorOccurred(event);
    }

    protected VistaSocketConnection getSocketConnection() {
        return this.socketCon;
    }

    public long getSocketTimeOut() {
        return this.socketTimeOut;
    }

    public void setSocketTimeOut(long socketTimeOut) {
        this.socketTimeOut = this.getAdapterEnvironment().equals(EMAdapterEnvironment.J2EE) && this.managedConnectionFactory.isAlwaysUseDefaultAsMin() ? (socketTimeOut < this.managedConnectionFactory.getDefaultJ2EETimeOut() ? this.managedConnectionFactory.getDefaultJ2EETimeOut() : socketTimeOut) : socketTimeOut;
    }

    void setDefaultSocketTimeOut() {
        this.socketTimeOut = this.managedConnectionFactory.getSocketTimeOut();
    }

    public String toString() {
        String adapterEnvironmentString = "";
        if (this.getAdapterEnvironment() != null) {
            adapterEnvironmentString = this.getAdapterEnvironment().toString();
        }
        return this.getClass().getName() + "[]" + this.getHostAddr().getHostAddress() + "[]" + this.getHostPort() + "[]" + this.getMaxConnectionHandles() + "[]" + adapterEnvironmentString + "[fdi]" + this.getFactoryDistinguishedIdentifier() + "[mdi]" + this.distinguishedIdentifier;
    }

    protected EMAdapterEnvironment getAdapterEnvironment() {
        return this.getManagedConnectionFactory().getAdapterEnvironment();
    }

    private void addToTimerTask() throws VistaLinkResourceException {
        try {
            this.getManagedConnectionFactory().getHeartBeatTimerManager().addManagedConnection(this, this.getHeartBeatRate());
        }
        catch (HeartBeatInitializationFailedException e) {
            this.setValid(false);
            throw e;
        }
        if (logger.isDebugEnabled()) {
            String debugMsg = this.getLoggerFormattedString("Added managedconnection to Heartbeat TimerTask");
            logger.debug((Object)debugMsg);
        }
    }

    private void removeFromTimerTask() {
        this.getManagedConnectionFactory().getHeartBeatTimerManager().removeManagedConnection(this);
        if (logger.isDebugEnabled()) {
            String debugMsg = this.getLoggerFormattedString("removed managedconnection to Heartbeat TimerTask");
            logger.debug((Object)debugMsg);
        }
    }

    public long getLastInteractionTimeMillis() {
        return this.lastInteractionTimeMillis;
    }

    public void setLastInteractionTimeMillis(long lastinteractiontimemillis) {
        this.lastInteractionTimeMillis = lastinteractiontimemillis;
    }

    protected long getLastTimeRpcExecutedMillis() {
        return this.lastTimeRpcExecutedMillis;
    }

    private void setHeartBeatRate(long heartBeatRate) {
        this.heartBeatRate = heartBeatRate;
        if (logger.isDebugEnabled()) {
            String debugMsg = this.getLoggerFormattedString("Heartbeat rate set successfully[]" + heartBeatRate);
            logger.debug((Object)debugMsg);
        }
    }

    protected long getHeartBeatRate() {
        return this.heartBeatRate;
    }

    protected String getMJob() {
        return this.mJob;
    }

    protected void setMJob(String mJob) {
        this.mJob = mJob;
        logger.debug((Object)this.getLoggerFormattedString("M $JOB set successfully[]" + mJob));
    }

    protected long getReAuthSessionTimeout() {
        return this.reAuthSessionTimeout;
    }

    protected void setReAuthSessionTimeout(long reAuthSessionTimeout) {
        this.reAuthSessionTimeout = reAuthSessionTimeout;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    private String getLoggerFormattedString(String log) {
        return this.toString() + (" M $JOB=" + this.mJob) + "\n\t" + log;
    }

    private String getLoggerFormattedStringWStackTrace(Throwable e) {
        return this.getLoggerFormattedString(ExceptionUtils.getFullStackTrace((Throwable)e));
    }

    private String getLoggerFormattedStringWStackTrace(String log, Throwable e) {
        return this.getLoggerFormattedString(log + "\n\t" + ExceptionUtils.getFullStackTrace((Throwable)e));
    }

    public boolean equals(Object obj) {
        if (obj instanceof VistaLinkManagedConnection) {
            return this.distinguishedIdentifier == ((VistaLinkManagedConnection)obj).distinguishedIdentifier && this.managedConnectionFactory.getDistinguishedIdentifier() == ((VistaLinkManagedConnection)obj).getManagedConnectionFactory().getDistinguishedIdentifier();
        }
        return false;
    }

    private void setHashCode() {
        int HASHCODE_SEED;
        int returnVal = HASHCODE_SEED = 17;
        int mcfDistIdHashCode = (int)(this.managedConnectionFactory.getDistinguishedIdentifier() ^ this.managedConnectionFactory.getDistinguishedIdentifier() >>> 32);
        returnVal = 37 * returnVal + mcfDistIdHashCode;
        int distIdHashCode = (int)(this.distinguishedIdentifier ^ this.distinguishedIdentifier >>> 32);
        this.hashCode = returnVal = 37 * returnVal + distIdHashCode;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getAccessCode() {
        return this.getManagedConnectionFactory().getAccessCode();
    }

    public String getVerifyCode() {
        return this.getManagedConnectionFactory().getVerifyCode();
    }

    public VistaLinkConnectionRequestInfo getConnReqInfo() {
        return this.connReqInfo;
    }

    public String getConnReqInfoString() {
        VistaLinkConnectionRequestInfo info = this.getConnReqInfo();
        if (info == null) {
            return "Con Req Info is null";
        }
        return info.toString();
    }

    protected EMReAuthState getReAuthState() {
        return this.reAuthState;
    }

    protected void setReAuthState(EMReAuthState reAuthState) {
        this.reAuthState = reAuthState;
        if (this.reAuthState.equals(EMReAuthState.NOTAUTHENTICATED)) {
            this.lastTimeRpcExecutedMillis = 0L;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

