/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.spi;

import gov.va.med.exception.ExceptionUtils;
import gov.va.med.monitor.time.AuditTimer;
import gov.va.med.net.SocketManager;
import gov.va.med.net.VistaSocketException;
import gov.va.med.net.VistaSocketTimeOutException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class VistaSocketConnection
extends SocketManager {
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$vistalink$adapter$spi$VistaSocketConnection == null ? (class$gov$va$med$vistalink$adapter$spi$VistaSocketConnection = VistaSocketConnection.class$("gov.va.med.vistalink.adapter.spi.VistaSocketConnection")) : class$gov$va$med$vistalink$adapter$spi$VistaSocketConnection));
    private static final Logger auditLogger = Logger.getLogger((String)((class$gov$va$med$vistalink$adapter$spi$VistaSocketConnection == null ? (class$gov$va$med$vistalink$adapter$spi$VistaSocketConnection = VistaSocketConnection.class$("gov.va.med.vistalink.adapter.spi.VistaSocketConnection")) : class$gov$va$med$vistalink$adapter$spi$VistaSocketConnection).getName() + ".AuditLog"));
    protected static final String CLOSE_SOCKET_REQUEST = "<VistaLink messageType='gov.va.med.foundations.vistalink.system.request' version='1.5' mode='single call' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:noNamespaceSchemaLocation='vlSimpleRequest.xsd'><Request type='closeSocket'/></VistaLink>";
    private int port;
    private InetAddress address;
    static /* synthetic */ Class class$gov$va$med$vistalink$adapter$spi$VistaSocketConnection;

    protected VistaSocketConnection(InetAddress address, int port, String mcIdentifier) throws VistaSocketException {
        this.address = address;
        this.port = port;
        this.setMatchingIdentifier(mcIdentifier);
        try {
            this.setSoc(new Socket(this.address, this.port));
        }
        catch (IOException e) {
            String errStr = "Can not create TCP/IP socket.";
            if (logger.isEnabledFor(Priority.ERROR)) {
                String loggerMsg = this.getLoggerFormattedStringWStackTrace(errStr, e);
                logger.error((Object)loggerMsg);
            }
            throw new VistaSocketException(errStr, (Exception)e);
        }
    }

    public String transfer(String request) throws VistaSocketTimeOutException, VistaSocketException {
        boolean isAuditTimerEnabled = AuditTimer.isAuditTimerEnabled((Logger)auditLogger);
        AuditTimer auditTimer = null;
        if (isAuditTimerEnabled) {
            auditTimer = new AuditTimer(auditLogger);
            auditTimer.start();
        }
        this.sendData(request);
        String response = this.receiveData();
        if (isAuditTimerEnabled) {
            auditTimer.stop();
            auditTimer.log("Socket xfer (milli-secs):");
        }
        auditTimer = null;
        return response;
    }

    public void close() throws VistaSocketException {
        this.close(true);
    }

    public void closeDontNotify() throws VistaSocketException {
        this.close(false);
    }

    public void close(boolean notifyM) throws VistaSocketException {
        if (this.getSoc() != null) {
            String loggerMsg;
            String errStr;
            block7: {
                if (notifyM) {
                    try {
                        this.sendData(CLOSE_SOCKET_REQUEST);
                    }
                    catch (VistaSocketException e) {
                        errStr = "'Close Socket request failed. M/VistA has most likely terminated this connection";
                        if (!logger.isEnabledFor(Priority.ERROR)) break block7;
                        loggerMsg = this.getLoggerFormattedStringWStackTrace(errStr, e);
                        logger.error((Object)loggerMsg);
                    }
                }
            }
            try {
                this.getSoc().close();
            }
            catch (IOException e) {
                errStr = "Can not close socket connection.";
                if (logger.isEnabledFor(Priority.ERROR)) {
                    loggerMsg = this.getLoggerFormattedStringWStackTrace(errStr, e);
                    logger.error((Object)loggerMsg);
                }
                throw new VistaSocketException(errStr, (Exception)e);
            }
            this.setSoc(null);
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public void setTransferTimeOut(int timeout) throws VistaSocketException {
        try {
            this.getSoc().setSoTimeout(timeout);
        }
        catch (SocketException e) {
            String errStr = "Can not set socket timeout.";
            if (logger.isEnabledFor(Priority.ERROR)) {
                String loggerMsg = this.getLoggerFormattedStringWStackTrace(errStr, e);
                logger.error((Object)loggerMsg);
            }
            throw new VistaSocketException(errStr, (Exception)e);
        }
    }

    protected void finalize() throws Throwable {
        this.closeDontNotify();
        super.finalize();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[mdi]" + this.getMatchingIdentifier();
    }

    private String getLoggerFormattedString(String log) {
        return this.toString() + "\n\t" + log;
    }

    private String getLoggerFormattedStringWStackTrace(Throwable e) {
        return this.getLoggerFormattedString(ExceptionUtils.getFullStackTrace((Throwable)e));
    }

    private String getLoggerFormattedStringWStackTrace(String log, Throwable e) {
        return this.getLoggerFormattedString(log + "\n\t" + ExceptionUtils.getFullStackTrace((Throwable)e));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

