/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.security.m;

import gov.va.med.vistalink.security.m.SecurityDataSetupAndIntroTextResponse;
import gov.va.med.vistalink.security.m.SecurityVO;

public final class SecurityVOSetupAndIntroText
extends SecurityVO {
    private String introductoryText = "";
    private String serverName = "";
    private String volume = "";
    private String uci = "";
    private String device = "";
    private int logonRetryCount = 5;
    private int timeout = 0;
    private int port = 0;

    public SecurityVOSetupAndIntroText(int resultType, String resultMessage) {
        super(resultType, resultMessage);
    }

    public SecurityVOSetupAndIntroText() {
        super(0, "");
    }

    public SecurityVOSetupAndIntroText(SecurityDataSetupAndIntroTextResponse setupAndIntroResponseObj) {
        super(setupAndIntroResponseObj.getResultType(), setupAndIntroResponseObj.getResultMessage());
        this.introductoryText = setupAndIntroResponseObj.getSetupAndIntroTextInfo().getIntroductoryText();
        this.serverName = setupAndIntroResponseObj.getSetupAndIntroTextInfo().getServerName();
        this.volume = setupAndIntroResponseObj.getSetupAndIntroTextInfo().getVolume();
        this.uci = setupAndIntroResponseObj.getSetupAndIntroTextInfo().getUci();
        this.device = setupAndIntroResponseObj.getSetupAndIntroTextInfo().getDevice();
        this.logonRetryCount = setupAndIntroResponseObj.getSetupAndIntroTextInfo().getLogonRetryCount();
        this.timeout = setupAndIntroResponseObj.getSetupAndIntroTextInfo().getTimeout();
        this.port = setupAndIntroResponseObj.getSetupAndIntroTextInfo().getPort();
    }

    public void setIntroductoryText(String value) {
        this.introductoryText = this.addLineBreaksToIntroductoryText(value);
    }

    public String getIntroductoryText() {
        return this.introductoryText;
    }

    public void setServerName(String value) {
        this.serverName = value;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setVolume(String value) {
        this.volume = value;
    }

    public String getVolume() {
        return this.volume;
    }

    public void setLogonRetryCount(int count) {
        this.logonRetryCount = count;
    }

    public int getLogonRetryCount() {
        return this.logonRetryCount;
    }

    public void setUci(String value) {
        this.uci = value;
    }

    public String getUci() {
        return this.uci;
    }

    public void setDevice(String value) {
        this.device = value;
    }

    public String getDevice() {
        return this.device;
    }

    public void setTimeout(int value) {
        this.timeout = value;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setPort(int value) {
        this.port = value;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return "Server: " + this.serverName + " Volume: " + this.volume + " UCI: " + this.uci + " Device: " + this.device + " Intro Text Length: " + this.introductoryText.length() + " Timeout: " + this.timeout;
    }

    private String addLineBreaksToIntroductoryText(String introText) {
        String lineBreakString = "<BR>";
        int lineBreakStringLength = lineBreakString.length();
        StringBuffer sb = new StringBuffer();
        int lineStartPos = 0;
        int posNextBreak = introText.indexOf(lineBreakString, lineStartPos);
        if (posNextBreak < 0) {
            return introText;
        }
        while (posNextBreak > -1) {
            sb.append(introText.substring(lineStartPos, posNextBreak));
            sb.append("\n");
            lineStartPos = posNextBreak + lineBreakStringLength;
            posNextBreak = introText.indexOf(lineBreakString, posNextBreak + 1);
        }
        return sb.toString();
    }
}

