/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.xml;

import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtilities {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$xml$XmlUtilities == null ? (class$gov$va$med$xml$XmlUtilities = XmlUtilities.class$("gov.va.med.xml.XmlUtilities")) : class$gov$va$med$xml$XmlUtilities));
    private static DocumentBuilderFactory documentBuilderFactory = null;
    private static TransformerFactory transformerFactory = null;
    private static ThreadLocalDocumentBuilder threadDocumentBuilder;
    private static ThreadLocalTransformer threadTransformer;
    static /* synthetic */ Class class$gov$va$med$xml$XmlUtilities;

    public static String convertXmlToStr(Document doc) throws FoundationsException {
        StringWriter sw = new StringWriter();
        try {
            threadTransformer.getTransformer().transform(new DOMSource(doc), new StreamResult(sw));
        }
        catch (TransformerException e) {
            String errStr = "Exception occured transforming DOM to String.";
            if (logger.isEnabledFor(Priority.ERROR)) {
                logger.error((Object)(errStr + "\n\t" + ExceptionUtils.getFullStackTrace(e)));
            }
            throw new FoundationsException(errStr, e);
        }
        return sw.toString();
    }

    public static Node getNode(String xpathStr, Node node) {
        try {
            DOMXPath xpath = new DOMXPath(xpathStr);
            List list = xpath.selectNodes((Object)node);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("XPath " + xpathStr + " returned  " + list.size() + "nodes."));
            }
            if (list.size() == 0) {
                return null;
            }
            return (Node)list.get(0);
        }
        catch (JaxenException e) {
            if (logger.isEnabledFor(Priority.ERROR)) {
                logger.error((Object)("Exception occured." + "\n\t" + ExceptionUtils.getFullStackTrace(e)));
            }
            return null;
        }
    }

    public static Attr getAttr(Node node, String attrName) {
        NamedNodeMap attrs = node.getAttributes();
        return (Attr)attrs.getNamedItem(attrName);
    }

    public static Document getDocumentForXmlString(String xml) throws FoundationsException {
        return XmlUtilities.getDocumentForXmlInputSource(new InputSource(new StringReader(xml)));
    }

    public static Document getDocumentForXmlInputStream(InputStream xml) throws FoundationsException {
        return XmlUtilities.getDocumentForXmlInputSource(new InputSource(xml));
    }

    private static Document getDocumentForXmlInputSource(InputSource xml) throws FoundationsException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using DocumentBuilderFactory factory " + documentBuilderFactory + "; and DocumentBuilder builder " + threadDocumentBuilder + "; InputStream xml = " + xml));
        }
        Document returnDoc = null;
        try {
            returnDoc = threadDocumentBuilder.getBuilder().parse(xml);
        }
        catch (SAXException e) {
            String errStr = "Can not parse xml into a Document - SAXException.";
            if (logger.isEnabledFor(Priority.ERROR)) {
                logger.error((Object)(errStr + "\n\t" + ExceptionUtils.getFullStackTrace(e)));
            }
            throw new FoundationsException(errStr, e);
        }
        catch (IOException e) {
            String errStr = "Can not parse xml into a Document - IOException.";
            if (logger.isEnabledFor(Priority.ERROR)) {
                logger.error((Object)(errStr + "\n\t" + ExceptionUtils.getFullStackTrace(e)));
            }
            throw new FoundationsException(errStr, e);
        }
        return returnDoc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        transformerFactory = TransformerFactory.newInstance();
        threadDocumentBuilder = new ThreadLocalDocumentBuilder();
        threadTransformer = new ThreadLocalTransformer();
    }

    private static class ThreadLocalTransformer
    extends ThreadLocal {
        private ThreadLocalTransformer() {
        }

        public Transformer getTransformer() throws FoundationsException {
            Transformer transformer = (Transformer)this.get();
            if (transformer == null) {
                throw new FoundationsException("Exception occured trying to create Transformer. See error log for details.");
            }
            return transformer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object initialValue() {
            TransformerFactory transformerFactory = transformerFactory;
            synchronized (transformerFactory) {
                try {
                    Transformer transformer = transformerFactory.newTransformer();
                    Properties oprops = new Properties();
                    oprops.put("method", "xml");
                    transformer.setOutputProperties(oprops);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using Transformer implementation: " + transformer.getClass().getName()));
                    }
                    return transformer;
                }
                catch (TransformerConfigurationException e) {
                    logger.error((Object)("Exception occured trying to create Transformer." + "\n\t" + ExceptionUtils.getFullStackTrace(e)));
                    return null;
                }
            }
        }
    }

    private static class ThreadLocalDocumentBuilder
    extends ThreadLocal {
        private ThreadLocalDocumentBuilder() {
        }

        public DocumentBuilder getBuilder() throws FoundationsException {
            DocumentBuilder builder = (DocumentBuilder)this.get();
            if (builder == null) {
                throw new FoundationsException("Can not get DocumentBuilder from DocumentBuilderFactory - check JAXP configuration/classpaths. See error log for details.");
            }
            return builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object initialValue() {
            DocumentBuilderFactory documentBuilderFactory = documentBuilderFactory;
            synchronized (documentBuilderFactory) {
                try {
                    DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using DocumentBuilder implementation: " + builder.getClass().getName()));
                    }
                    return builder;
                }
                catch (ParserConfigurationException e) {
                    logger.error((Object)("Can not get DocumentBuilder from DocumentBuilderFactory - check JAXP configuration/classpaths." + "\n\t" + ExceptionUtils.getFullStackTrace(e)));
                    return null;
                }
            }
        }
    }
}

