/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.record;

import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.record.LoginsDisabledFaultException;
import gov.va.med.vistalink.adapter.record.NoJobSlotsAvailableFaultException;
import gov.va.med.vistalink.adapter.record.VistaLinkFaultException;
import gov.va.med.vistalink.adapter.record.VistaLinkRequestVO;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseFactory;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseVO;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseVOImpl;
import gov.va.med.xml.XmlUtilities;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class VistaLinkResponseFactoryImpl
implements VistaLinkResponseFactory {
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$vistalink$adapter$record$VistaLinkResponseFactoryImpl == null ? (class$gov$va$med$vistalink$adapter$record$VistaLinkResponseFactoryImpl = VistaLinkResponseFactoryImpl.class$("gov.va.med.vistalink.adapter.record.VistaLinkResponseFactoryImpl")) : class$gov$va$med$vistalink$adapter$record$VistaLinkResponseFactoryImpl));
    protected static final String GOV_VA_MED_FOUNDATIONS_FAULT = "gov.va.med.foundations.vistalink.system.fault";
    protected static final String ERROR_MSG_GEN = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><VistaLink messageType=\"gov.va.med.foundations.vistalink.system.fault";
    protected static final String SUFFIX = "</Response></VistaLink>";
    protected static final String VISTALINK_ROOT_ELEMENT = "VistaLink";
    static /* synthetic */ Class class$gov$va$med$vistalink$adapter$record$VistaLinkResponseFactoryImpl;

    public VistaLinkResponseVO handleResponse(String response, VistaLinkRequestVO requestVO) throws FoundationsException {
        try {
            return this.parseMessageHeader(response, requestVO);
        }
        catch (VistaLinkFaultException e) {
            throw e;
        }
        catch (FoundationsException e) {
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = "Exception occured parsing response." + "\n\t" + ExceptionUtils.getFullStackTrace((Throwable)e);
                logger.error((Object)errMsg);
            }
            throw e;
        }
    }

    private VistaLinkResponseVO parseMessageHeader(String rawXml, VistaLinkRequestVO requestVO) throws VistaLinkFaultException, FoundationsException {
        boolean isFault = this.doesResponseIndicateFaultCommon(rawXml) || this.doesResponseIndicateFault(rawXml);
        VistaLinkResponseVO resp = null;
        Document doc = null;
        String filteredXml = this.filterResponseXmlString(rawXml, isFault);
        doc = XmlUtilities.getDocumentForXmlString((String)filteredXml);
        if (!doc.getDocumentElement().getNodeName().equals(VISTALINK_ROOT_ELEMENT)) {
            throw new FoundationsException("Root element of response is not VistaLink.");
        }
        String version = ((Attr)doc.getDocumentElement().getAttributes().getNamedItem("version")).getValue();
        if (!version.equals("1.5")) {
            throw new FoundationsException("The response version [" + version + "] is incompatible with this version of the adapter [" + "1.5" + "]");
        }
        String messageType = ((Attr)doc.getDocumentElement().getAttributes().getNamedItem("messageType")).getValue();
        if (isFault) {
            this.handleFault(doc, messageType);
        } else {
            resp = this.parseMessageBody(rawXml, filteredXml, doc, messageType, requestVO);
        }
        return resp;
    }

    private boolean doesResponseIndicateFaultCommon(String rawXml) {
        return rawXml.startsWith(ERROR_MSG_GEN);
    }

    protected boolean doesResponseIndicateFault(String rawXml) {
        return false;
    }

    protected String filterResponseXmlString(String rawXml, boolean isFault) {
        return rawXml;
    }

    protected VistaLinkResponseVO parseMessageBody(String rawXml, String filteredXml, Document doc, String messageType, VistaLinkRequestVO requestVO) throws FoundationsException {
        return new VistaLinkResponseVOImpl(rawXml, filteredXml, doc, messageType);
    }

    protected final void handleFault(Document xdoc, String messageType) throws VistaLinkFaultException, FoundationsException {
        String faultCode = "";
        String faultString = "";
        String faultActor = "";
        String errorCode = "";
        String errorType = "";
        String errorMessage = "";
        try {
            Node msgNode;
            Node faultActorNode;
            Node faultStringNode;
            DOMXPath xpath = new DOMXPath("VistaLink/Fault/FaultCode/text()");
            Node faultCodeNode = (Node)xpath.selectSingleNode((Object)xdoc);
            if (faultCodeNode != null && faultCodeNode.getNodeType() == 3) {
                faultCode = ((Text)faultCodeNode).getData();
            }
            if ((faultStringNode = (Node)(xpath = new DOMXPath("VistaLink/Fault/FaultString/text()")).selectSingleNode((Object)xdoc)) != null && faultStringNode.getNodeType() == 3) {
                faultString = ((Text)faultStringNode).getData();
            }
            if ((faultActorNode = (Node)(xpath = new DOMXPath("VistaLink/Fault/FaultActor/text()")).selectSingleNode((Object)xdoc)) != null && faultActorNode.getNodeType() == 3) {
                faultActor = ((Text)faultActorNode).getData();
            }
            xpath = new DOMXPath("/VistaLink/Fault/Detail/Error/.");
            Node errorNode = (Node)xpath.selectSingleNode((Object)xdoc);
            errorCode = ((Attr)errorNode.getAttributes().getNamedItem("code")).getValue();
            Attr errorTypeAttr = (Attr)errorNode.getAttributes().getNamedItem("type");
            if (errorTypeAttr != null) {
                errorType = errorTypeAttr.getValue();
            }
            if ((msgNode = (Node)(xpath = new DOMXPath("/VistaLink/Fault/Detail/Error/Message/text()")).selectSingleNode((Object)xdoc)) != null) {
                errorMessage = msgNode.getNodeValue();
            }
            VistaLinkFaultException faultException = new VistaLinkFaultException(errorCode, errorMessage, errorType, faultActor, faultCode, faultString);
            VistaLinkFaultException specificFaultException = this.handleAndDelegateSpecificFault(xdoc, messageType, faultException);
            throw specificFaultException;
        }
        catch (JaxenException e) {
            throw new FoundationsException("Exception parsing XML.", (Throwable)e);
        }
    }

    private VistaLinkFaultException handleAndDelegateSpecificFault(Document xdoc, String messageType, VistaLinkFaultException faultException) throws VistaLinkFaultException, FoundationsException {
        if ("181003".equals(faultException.getErrorCode())) {
            return new NoJobSlotsAvailableFaultException(faultException);
        }
        if ("181004".endsWith(faultException.getErrorCode())) {
            return new LoginsDisabledFaultException(faultException);
        }
        VistaLinkFaultException returnFaultException = this.handleSpecificFault(xdoc, messageType, faultException);
        if (returnFaultException == null) {
            returnFaultException = faultException;
        }
        return returnFaultException;
    }

    protected VistaLinkFaultException handleSpecificFault(Document xdoc, String messageType, VistaLinkFaultException faultException) throws VistaLinkFaultException, FoundationsException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

