/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.spi;

import gov.va.med.crypto.EncrypterRegistry;
import gov.va.med.vistalink.adapter.cci.VistaLinkResourceException;
import gov.va.med.vistalink.adapter.config.ConnectorsDocument;
import gov.va.med.vistalink.adapter.spi.VistaLinkManagedConnectionFactory;
import gov.va.med.vistalink.institution.InstitutionMappingBadStationNumberException;
import gov.va.med.vistalink.institution.InstitutionMappingImpl;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;

public class ConfigurationReader {
    public static final String CONFIG_FILE_PATH = "/gov.va.med.vistalink.connectorConfig.xml";
    static /* synthetic */ Class class$gov$va$med$vistalink$adapter$spi$ConfigurationReader;
    static /* synthetic */ Class class$gov$va$med$crypto$DESPassPhraseEncrypter;

    /*
     * Unable to fully structure code
     */
    protected static void parseConfig(VistaLinkManagedConnectionFactory mcf) throws VistaLinkResourceException {
        block32: {
            logger = Logger.getLogger((Class)(ConfigurationReader.class$gov$va$med$vistalink$adapter$spi$ConfigurationReader == null ? (ConfigurationReader.class$gov$va$med$vistalink$adapter$spi$ConfigurationReader = ConfigurationReader.class$("gov.va.med.vistalink.adapter.spi.ConfigurationReader")) : ConfigurationReader.class$gov$va$med$vistalink$adapter$spi$ConfigurationReader));
            connectorJndiName = mcf.getConnectorJndiName();
            saveFile = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ConnectorJndiName index: " + connectorJndiName));
            }
            if (connectorJndiName == null) {
                error = "Connector descriptor is not configured with connectorJndiName to be retrieved from configuration file.";
                throw new VistaLinkResourceException(error);
            }
            connectorConfig = null;
            enabledMatchCount = 0;
            try {
                block31: {
                    try {
                        connectorConfig = (ConfigurationReader.class$gov$va$med$vistalink$adapter$spi$ConfigurationReader == null ? (ConfigurationReader.class$gov$va$med$vistalink$adapter$spi$ConfigurationReader = ConfigurationReader.class$("gov.va.med.vistalink.adapter.spi.ConfigurationReader")) : ConfigurationReader.class$gov$va$med$vistalink$adapter$spi$ConfigurationReader).getResourceAsStream("/gov.va.med.vistalink.connectorConfig.xml");
                        logger.info((Object)("Opened VistaLink configuration file at: " + (ConfigurationReader.class$gov$va$med$vistalink$adapter$spi$ConfigurationReader == null ? (ConfigurationReader.class$gov$va$med$vistalink$adapter$spi$ConfigurationReader = ConfigurationReader.class$("gov.va.med.vistalink.adapter.spi.ConfigurationReader")) : ConfigurationReader.class$gov$va$med$vistalink$adapter$spi$ConfigurationReader).getResource("/gov.va.med.vistalink.connectorConfig.xml").getPath()));
                    }
                    catch (Exception e) {
                        throw new VistaLinkResourceException("Could not open vistalink configuration file '/gov.va.med.vistalink.connectorConfig.xml'.", e);
                    }
                    config = ConnectorsDocument.Factory.parse(connectorConfig);
                    connectors = config.getConnectors().getConnectorArray();
                    for (i = 0; i < connectors.length; ++i) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Given connectorJndiName '" + connectorJndiName + "' from ra.xml custom property"));
                        }
                        if (!connectors[i].getEncrypted()) {
                            start = 0L;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("found unencrypted entries, encrypting for: " + connectors[i].getJndiName()));
                                start = System.currentTimeMillis();
                            }
                            connectors[i].setAccessCode(ConfigurationReader.getEncrypted(connectors[i].getAccessCode()));
                            connectors[i].setVerifyCode(ConfigurationReader.getEncrypted(connectors[i].getVerifyCode()));
                            connectors[i].setEncrypted(true);
                            saveFile = true;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("finished encrypting (" + (System.currentTimeMillis() - start) + " ms) entries for: " + connectors[i].getJndiName()));
                            }
                        }
                        if (!connectorJndiName.equals(connectors[i].getJndiName())) continue;
                        if (connectors[i].getEnabled()) {
                            if (++enabledMatchCount > 1) {
                                throw new VistaLinkResourceException("Multiple entries in VistaLink configuration file are enabled and have the same connectorJndiName, '" + connectorJndiName + "'.");
                            }
                            logger.debug((Object)"found match.");
                            mcf.setHostIpAddress(connectors[i].getIp());
                            mcf.setHostPort(connectors[i].getPort());
                            if (connectors[i].getEncrypted()) {
                                logger.debug((Object)"found encrypted entries, decrypting...");
                                mcf.setAccessCode(ConfigurationReader.getDecrypted(connectors[i].getAccessCode()));
                                mcf.setVerifyCode(ConfigurationReader.getDecrypted(connectors[i].getVerifyCode()));
                            } else {
                                logger.warn((Object)("unencrypted entry in the config file! - " + connectorJndiName));
                            }
                            mcf.setDefaultJ2EETimeOut(connectors[i].getTimeout() * 1000);
                            mcf.setAlwaysUseDefaultAsMin(connectors[i].getAlwaysUseDefaultAsMin());
                            primaryStation = Integer.toString(connectors[i].getPrimaryStation());
                            if (connectors[i].getPrimaryStationSuffix() != null) {
                                primaryStation = primaryStation + connectors[i].getPrimaryStationSuffix();
                            }
                            mcf.setPrimaryStation(primaryStation);
                            if (primaryStation.length() > 0) {
                                instMap = InstitutionMappingImpl.getInstance();
                                stationNumbersToMap = new String[]{primaryStation};
                                try {
                                    instMap.loadMappingsForJndiName(connectorJndiName, stationNumbersToMap, mcf.getDefaultJ2EETimeOut());
                                }
                                catch (InstitutionMappingBadStationNumberException e1) {
                                    throw new VistaLinkResourceException("Could not load institution mapping for connector JNDI name: '" + connectorJndiName + "' due to bad station number(s): '" + e1.getMessage() + "'.", (Exception)e1);
                                }
                            } else {
                                throw new VistaLinkResourceException("primary Station not found; this attribute is required for connector configuration.");
                            }
                            mcf.setConnectorEnabled(connectors[i].getEnabled());
                            continue;
                        }
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Skipping disabled connector '" + connectorJndiName + "'."));
                    }
                    if (!saveFile) break block31;
                    config.save(new File((ConfigurationReader.class$gov$va$med$vistalink$adapter$spi$ConfigurationReader == null ? (ConfigurationReader.class$gov$va$med$vistalink$adapter$spi$ConfigurationReader = ConfigurationReader.class$("gov.va.med.vistalink.adapter.spi.ConfigurationReader")) : ConfigurationReader.class$gov$va$med$vistalink$adapter$spi$ConfigurationReader).getResource("/gov.va.med.vistalink.connectorConfig.xml").getPath()));
                }
                var14_23 = null;
                ** if (connectorConfig == null) goto lbl-1000
            }
            catch (Throwable var13_27) {
                var14_24 = null;
                if (connectorConfig != null) {
                    try {
                        connectorConfig.close();
                    }
                    catch (IOException e1) {
                        logger.error((Object)"Problem closing config file input stream: ", (Throwable)e1);
                    }
                }
                throw var13_27;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    connectorConfig.close();
                }
                catch (IOException e1) {
                    logger.error((Object)"Problem closing config file input stream: ", (Throwable)e1);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block32;
                catch (VistaLinkResourceException e) {
                    throw e;
                }
                catch (XmlException e) {
                    error = "Problem parsing config file. ";
                    throw new VistaLinkResourceException(error, (Exception)e);
                }
                catch (IOException e) {
                    error = "Problem opening or saving a config file. ";
                    throw new VistaLinkResourceException(error, e);
                }
                catch (Exception e) {
                    error = "Problem parsing config file. ";
                    throw new VistaLinkResourceException(error, e);
                }
            }
        }
        if (enabledMatchCount == 0) {
            throw new VistaLinkResourceException("Could not find matching configuration for connectorJndiName '" + connectorJndiName + "'.");
        }
    }

    private static String getDecrypted(String encrypted) {
        return EncrypterRegistry.getInstance((Class)(class$gov$va$med$crypto$DESPassPhraseEncrypter == null ? (class$gov$va$med$crypto$DESPassPhraseEncrypter = ConfigurationReader.class$("gov.va.med.crypto.DESPassPhraseEncrypter")) : class$gov$va$med$crypto$DESPassPhraseEncrypter)).decrypt(encrypted);
    }

    private static String getEncrypted(String original) {
        return EncrypterRegistry.getInstance((Class)(class$gov$va$med$crypto$DESPassPhraseEncrypter == null ? (class$gov$va$med$crypto$DESPassPhraseEncrypter = ConfigurationReader.class$("gov.va.med.crypto.DESPassPhraseEncrypter")) : class$gov$va$med$crypto$DESPassPhraseEncrypter)).encrypt(original);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

