/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.spi;

import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionFactory;
import gov.va.med.vistalink.adapter.spi.ConnectorInfoVO;
import gov.va.med.vistalink.adapter.spi.VistaLinkRuntimeInfoMBean;
import gov.va.med.vistalink.institution.InstitutionMappingImpl;
import gov.va.med.vistalink.institution.InstitutionMappingVO;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import weblogic.management.MBeanHome;
import weblogic.management.RemoteMBeanServer;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ConnectorComponentMBean;
import weblogic.management.runtime.ApplicationRuntimeMBean;
import weblogic.management.runtime.ConnectorComponentRuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;

public class VistaLinkRuntimeInfo
implements VistaLinkRuntimeInfoMBean {
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$vistalink$adapter$spi$VistaLinkRuntimeInfo == null ? (class$gov$va$med$vistalink$adapter$spi$VistaLinkRuntimeInfo = VistaLinkRuntimeInfo.class$("gov.va.med.vistalink.adapter.spi.VistaLinkRuntimeInfo")) : class$gov$va$med$vistalink$adapter$spi$VistaLinkRuntimeInfo));
    private ObjectName objectName;
    private MBeanHome localHome;
    private String domainName;
    private String localServerName;
    static /* synthetic */ Class class$gov$va$med$vistalink$adapter$spi$VistaLinkRuntimeInfo;

    public VistaLinkRuntimeInfo() throws NamingException {
        logger.debug((Object)"in constructor");
        this.initialize();
    }

    private void initialize() throws NamingException {
        try {
            InitialContext ctx = new InitialContext();
            this.localHome = (MBeanHome)ctx.lookup("weblogic.management.home.localhome");
            this.domainName = this.localHome.getDomainName();
            this.localServerName = VistaLinkRuntimeInfo.getServerName(this.localHome);
        }
        catch (NamingException e) {
            logger.error((Object)"Initialization failed: ", (Throwable)e);
            throw e;
        }
    }

    private static String getServerName(MBeanHome localHome) {
        String returnVal = null;
        Set serverMBeans = localHome.getMBeansByType("ServerRuntime");
        Iterator iter = serverMBeans.iterator();
        if (iter.hasNext()) {
            returnVal = ((ServerRuntimeMBean)iter.next()).getName();
        }
        return returnVal;
    }

    public Map retrieveConnectorList() {
        TreeMap<String, ConnectorInfoVO> returnVal = new TreeMap<String, ConnectorInfoVO>();
        RemoteMBeanServer localMBeanServer = this.localHome.getMBeanServer();
        Set connectorMBeanSet = this.localHome.getMBeansByType("ConnectorComponentRuntime");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("found " + connectorMBeanSet.size() + " ConnectorComponentRuntime mbeans"));
        }
        Iterator connectorIter = connectorMBeanSet.iterator();
        while (connectorIter.hasNext()) {
            ConnectorInfoVO cisVO = new ConnectorInfoVO();
            ConnectorComponentRuntimeMBean runtimeMBean = (ConnectorComponentRuntimeMBean)connectorIter.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("retrieving info for ConnectorComponentRuntimeMBean: '" + runtimeMBean.getObjectName().getCanonicalName() + "'."));
            }
            this.getConnectorInfo(cisVO, runtimeMBean, false);
            if ("VistA".equals(cisVO.getWlsEisType()) || cisVO.getWlsEisType() == null) {
                returnVal.put(runtimeMBean.getObjectName().getCanonicalName(), cisVO);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("skipping connector EisType: '" + cisVO.getWlsEisType() + "'."));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning connector list with " + returnVal.size() + " entries."));
        }
        return returnVal;
    }

    private String getVistaLinkConfigJndiName(ConnectorComponentMBean configMBean) {
        String returnVal = null;
        try {
            logger.debug((Object)"About to get ConfigProperties Hashtable");
            Hashtable configProperties = (Hashtable)configMBean.getAttribute("ConfigProperties");
            logger.debug((Object)"about to get connectorJndiName from ConfigProperties");
            if (configProperties == null) {
                logger.debug((Object)"... but ConfigProperties is null.");
            } else if (!configProperties.containsKey("connectorJndiName")) {
                logger.debug((Object)"... but ConfigProperties doesn't contain 'connectorJndiName' key");
            } else {
                logger.debug((Object)"configProperties contained the key 'connectorJndiName'");
                Hashtable ht1 = (Hashtable)configProperties.get("connectorJndiName");
                if (ht1 == null) {
                    logger.debug((Object)"could not retrieve connectorJndiName inner Hashtable, it is null");
                } else {
                    returnVal = (String)ht1.get("Value");
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(" found connectorJndiName = " + returnVal));
                    }
                }
            }
        }
        catch (AttributeNotFoundException e) {
            logger.error((Object)e);
        }
        catch (MBeanException e) {
            logger.error((Object)e);
        }
        catch (ReflectionException e) {
            logger.error((Object)e);
        }
        return returnVal;
    }

    public ConnectorInfoVO retrieveConnectorDetailInfo(String canonicalRuntimeMBeanObjectName) {
        ConnectorInfoVO cisVO = new ConnectorInfoVO();
        try {
            ConnectorComponentRuntimeMBean runtimeMBean = (ConnectorComponentRuntimeMBean)this.localHome.getMBean(new ObjectName(canonicalRuntimeMBeanObjectName));
            this.getConnectorInfo(cisVO, runtimeMBean, true);
        }
        catch (InstanceNotFoundException e) {
            logger.warn((Object)("Could not find MBean for '" + canonicalRuntimeMBeanObjectName + "'; perhaps the connector was undeployed."));
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)e);
        }
        catch (NullPointerException e) {
            logger.error((Object)e);
        }
        return cisVO;
    }

    private void getConnectorInfo(ConnectorInfoVO cisVO, ConnectorComponentRuntimeMBean runtimeMBean, boolean getDetailInfo) {
        cisVO.setWlsDeploymentState(runtimeMBean.getDeploymentState());
        cisVO.setWlsDeploymentStateString(this.getWlsDeploymentStateName(runtimeMBean.getDeploymentState()));
        ConnectorComponentMBean matchingConfigMBean = this.getConnectorConfigMBean(runtimeMBean);
        if (matchingConfigMBean == null) {
            logger.debug((Object)"Did not find a matching ConnectorComponent config mbean.");
        } else {
            logger.debug((Object)"got matching config mbean for runtime.");
            try {
                String eisType;
                String appName = matchingConfigMBean.getObjectName().getKeyProperty("ApplicationConfig");
                if (appName != null) {
                    cisVO.setWlsApplicationName(appName);
                }
                if ((eisType = (String)matchingConfigMBean.getAttribute("EisType")) != null) {
                    cisVO.setWlsEisType(eisType);
                    if (eisType.equals("VistA")) {
                        cisVO.setWlsEisType("VistA");
                        String deployedJndiName = (String)matchingConfigMBean.getAttribute("JndiName");
                        if (deployedJndiName != null) {
                            cisVO.setWlsJndiActual(deployedJndiName);
                            cisVO.setCfgJndiName(this.getVistaLinkConfigJndiName(matchingConfigMBean));
                            logger.debug((Object)"about to get CF");
                            VistaLinkConnectionFactory cf = this.getCF(deployedJndiName, runtimeMBean);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("got CF: " + cf));
                            }
                            if (cf != null) {
                                cf.getMCFInfo(cisVO, getDetailInfo);
                            }
                            if (getDetailInfo) {
                                cisVO.setWlsConnectionFactoryName((String)matchingConfigMBean.getAttribute("ConnectionFactoryName"));
                                cisVO.setWlsResourceAdapterLinkRef((String)matchingConfigMBean.getAttribute("RALinkRef"));
                                cisVO.setCfgStationNumbers(this.getStationNumbers(deployedJndiName));
                            }
                            logger.debug((Object)"done with MCF");
                        }
                    }
                }
            }
            catch (AttributeNotFoundException e) {
                logger.error((Object)e);
            }
            catch (MBeanException e) {
                logger.error((Object)e);
            }
            catch (ReflectionException e) {
                logger.error((Object)e);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private String[] getStationNumbers(String deployedJndiName) {
        String[] stationNumbers = null;
        logger.debug((Object)("looking for live mappings for jndi name # '" + deployedJndiName + "'."));
        InstitutionMappingImpl me = InstitutionMappingImpl.getInstance();
        Map institutionMap = me.getMappingClone();
        TreeSet<String> matchingStations = new TreeSet<String>();
        Set keys = institutionMap.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String stationNumber = (String)iter.next();
            InstitutionMappingVO imVO = (InstitutionMappingVO)institutionMap.get(stationNumber);
            String mappingJndiName = imVO.getJndiName();
            if (!mappingJndiName.equals(deployedJndiName)) continue;
            matchingStations.add(stationNumber);
            logger.debug((Object)("found matching station # '" + stationNumber + "'."));
        }
        if (matchingStations.size() > 0) {
            stationNumbers = new String[matchingStations.size()];
            int i = 0;
            Iterator iter2 = matchingStations.iterator();
            while (iter2.hasNext()) {
                stationNumbers[i] = (String)iter2.next();
                ++i;
            }
        }
        return stationNumbers;
    }

    private VistaLinkConnectionFactory getCF(String jndiName, ConnectorComponentRuntimeMBean runtimeMBean) {
        VistaLinkConnectionFactory cf = null;
        try {
            InitialContext ctx = new InitialContext();
            cf = (VistaLinkConnectionFactory)ctx.lookup(jndiName);
        }
        catch (NamingException e) {
            int deploymentState = runtimeMBean.getDeploymentState();
            if (deploymentState == 2) {
                logger.error((Object)e);
            }
            logger.debug((Object)("Encountered NamingException trying to retrieve connection factory '" + jndiName + "' from JNDI, but deployment state is " + this.getWlsDeploymentStateName(deploymentState)));
        }
        return cf;
    }

    private ConnectorComponentMBean getConnectorConfigMBean(ConnectorComponentRuntimeMBean runtimeMBean) {
        ConnectorComponentMBean matchingConfigBean;
        block17: {
            matchingConfigBean = null;
            try {
                ApplicationMBean appConfigMBean;
                ApplicationRuntimeMBean appRuntimeMBean = (ApplicationRuntimeMBean)runtimeMBean.getParent();
                if (appRuntimeMBean == null) {
                    logger.error((Object)"Could not get matching ApplicationRuntimeMBean");
                    break block17;
                }
                String appName = (String)appRuntimeMBean.getAttribute("ApplicationName");
                if (appName == null) {
                    logger.error((Object)"could not get ApplicationName attribute.");
                    break block17;
                }
                String domainName = this.localHome.getDomainName();
                StringBuffer nameBuffer = new StringBuffer(domainName);
                nameBuffer.append(":Location=").append(this.localServerName).append(",Name=").append(appName).append(",Type=ApplicationConfig");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Looking for ObjectName: '" + nameBuffer.toString() + "'."));
                }
                if ((appConfigMBean = (ApplicationMBean)this.localHome.getMBean(new ObjectName(nameBuffer.toString()))) == null) {
                    logger.debug((Object)"could not retrieve matching ApplicationConfigMBean.");
                    break block17;
                }
                logger.debug((Object)"found matching ApplicationConfigMBean.");
                QueryExp query = null;
                RemoteMBeanServer localMBeanServer = this.localHome.getMBeanServer();
                nameBuffer = new StringBuffer(domainName);
                nameBuffer.append(":ApplicationConfig=").append(appName);
                nameBuffer.append(",Location=").append(this.localServerName);
                nameBuffer.append(",Type=ConnectorComponentConfig,*");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Looking for ObjectName: '" + nameBuffer.toString() + "'."));
                }
                Set<ObjectInstance> connectorConfigBeanObjectNames = localMBeanServer.queryMBeans(new ObjectName(nameBuffer.toString()), query);
                Iterator<ObjectInstance> iter = connectorConfigBeanObjectNames.iterator();
                while (iter.hasNext()) {
                    ObjectInstance objInstance = iter.next();
                    if (!"weblogic.management.configuration.ConnectorComponentMBean".equals(objInstance.getClassName())) {
                        logger.error((Object)("Expected to find object of class ConnectorComponentMBean, instead found: " + objInstance.getClassName()));
                        continue;
                    }
                    ObjectName oName = objInstance.getObjectName();
                    ConnectorComponentMBean candidateConfigMBean = (ConnectorComponentMBean)this.localHome.getMBean(oName);
                    if (candidateConfigMBean == null) {
                        logger.error((Object)("Could not retrieve ConectorComponentMBean for ObjectName: " + oName.getCanonicalName()));
                        continue;
                    }
                    if (candidateConfigMBean.getParent() == appConfigMBean) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("found parent match! ConnectorComponentConfigMBean object name: " + candidateConfigMBean.getObjectName()));
                        }
                        matchingConfigBean = candidateConfigMBean;
                        break;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Not a match: ConnectorComponentConfigMBean object name: " + candidateConfigMBean.getObjectName()));
                }
            }
            catch (MalformedObjectNameException e) {
                logger.error((Object)e);
            }
            catch (AttributeNotFoundException e) {
                logger.error((Object)e);
            }
            catch (NullPointerException e) {
                logger.error((Object)e);
            }
            catch (MBeanException e) {
                logger.error((Object)e);
            }
            catch (ReflectionException e) {
                logger.error((Object)e);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return matchingConfigBean;
    }

    public String toString() {
        return this.objectName.toString();
    }

    public static String getServerSpecificCanonicalObjectName(String domainName, String serverName) {
        StringBuffer sb = new StringBuffer(domainName).append(":Name=").append(serverName).append("-").append("VistaLinkRuntimeInfo,Type=VistaLinkRuntimeInfo,Location=").append(serverName);
        return sb.toString();
    }

    public static VistaLinkRuntimeInfo register() {
        ObjectName mbeanObjectName = null;
        VistaLinkRuntimeInfo monitor = null;
        try {
            InitialContext ctx = new InitialContext();
            monitor = new VistaLinkRuntimeInfo();
            RemoteMBeanServer mbeanServer = monitor.localHome.getMBeanServer();
            String canonicalObjectName = VistaLinkRuntimeInfo.getServerSpecificCanonicalObjectName(monitor.domainName, monitor.localServerName);
            mbeanObjectName = new ObjectName(canonicalObjectName);
            ObjectInstance mbeanInstance = mbeanServer.registerMBean(monitor, mbeanObjectName);
            monitor.setObjectName(mbeanObjectName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("MBean '" + mbeanObjectName + "' registered."));
            }
        }
        catch (Exception e) {
            logger.error((Object)("MBean initialization or registration failed for '" + mbeanObjectName + "'."), (Throwable)e);
        }
        return monitor;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    private void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    private String getWlsDeploymentStateName(int deploymentState) {
        String returnVal = null;
        if (deploymentState == 3) {
            returnVal = "NEW";
        } else if (deploymentState == 0) {
            returnVal = "UNPREPARED";
        } else if (deploymentState == 1) {
            returnVal = "PREPARED";
        } else if (deploymentState == 2) {
            returnVal = "ACTIVATED";
        }
        return returnVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

