/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WeakValueMap
extends AbstractMap {
    private Logger logger = Logger.getLogger((Class)(class$gov$va$med$vistalink$cache$WeakValueMap == null ? (class$gov$va$med$vistalink$cache$WeakValueMap = WeakValueMap.class$("gov.va.med.vistalink.cache.WeakValueMap")) : class$gov$va$med$vistalink$cache$WeakValueMap));
    private final Map map = new HashMap();
    private final LinkedList strongRef = new LinkedList();
    private final int STRONG_SIZE;
    private final ReferenceQueue queue = new ReferenceQueue();
    static /* synthetic */ Class class$gov$va$med$vistalink$cache$WeakValueMap;

    public WeakValueMap() {
        this(1);
    }

    public WeakValueMap(int strongSize) {
        this.STRONG_SIZE = strongSize;
    }

    public Object get(Object key) {
        Object result = null;
        Reference ref = (Reference)this.map.get(key);
        if (ref != null) {
            result = ref.get();
            if (result == null) {
                this.logger.debug((Object)("map element <" + this.map.remove(key) + "> has been removed for the key: " + key));
            } else {
                this.strongRef.addFirst(result);
                if (this.strongRef.size() > this.STRONG_SIZE) {
                    this.strongRef.removeLast();
                    this.logger.debug((Object)("Bumped up the object <" + result + "> in the strong reference cache"));
                }
            }
        }
        return result;
    }

    public Set entrySet() {
        this.processQueue();
        return this.map.entrySet();
    }

    public String toString() {
        this.processQueue();
        return super.toString();
    }

    private void processQueue() {
        WeakValue sv = null;
        this.logger.debug((Object)"Processing the queue ...");
        while ((sv = (WeakValue)this.queue.poll()) != null) {
            this.map.remove(sv.key);
            this.logger.debug((Object)("Removed WeakValue: " + sv));
        }
    }

    public Object put(Object key, Object value) {
        this.processQueue();
        WeakValue sv = new WeakValue(value, key, this.queue);
        this.logger.debug((Object)("Putting a WeakValue: " + sv));
        return this.map.put(key, sv);
    }

    public Object remove(Object key) {
        this.processQueue();
        this.logger.debug((Object)("Removing WeakValue, based on key: " + key));
        return this.map.remove(key);
    }

    public void clear() {
        this.strongRef.clear();
        this.processQueue();
        this.map.clear();
    }

    public int size() {
        this.processQueue();
        return this.map.size();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WeakValue
    extends WeakReference {
        private final Object key;

        private WeakValue(Object referent, Object key, ReferenceQueue q) {
            super(referent, q);
            this.key = key;
        }

        public String toString() {
            return "Key: " + this.key + ", Value: " + this.get();
        }
    }
}

