package gov.va.med.edp.command
{
	import flash.system.System;
	import flash.utils.getQualifiedClassName;
    import flash.net.URLRequest;
    import flash.net.navigateToURL;

    import gov.va.med.edp.control.ClearUnsavedViewsModelEvent;
    import gov.va.med.edp.control.SwitchAppViewEvent
    import gov.va.med.edp.model.TrackingModelLocator;
    import gov.va.med.edp.view.ErrorDialog;

import mx.core.Application;
import mx.events.CloseEvent;
    import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
    import mx.rpc.http.HTTPService;

    public class AbstractResponderCommand implements IResponder
	{  
        public function result(data:Object):void {
			// NOOP: must override
		}
		
		public function fault(info:Object):void {
			var f:FaultEvent = info as FaultEvent;
			if (f.fault.faultCode == "Client.Error.RequestTimeout" || f.fault.faultCode == "Server.Error.Request") {
                handleServerUnavailable(f);
            } else if (f.fault.faultCode == HTTPService.ERROR_DECODING) {          // XML parser choking on HTML error page
                if (isLoginPage(String(f.fault.rootCause))) {
                    ErrorDialog.show("Your session appears to be invalid.\nYou will be now be asked to log in.\nUnsaved changes will be lost.", createFaultDetail(f), "Invalid Session", attemptLogin, "Login");
                } else {
                    handleServerError(f);
                }
            } else {
                handleUnknownError(f);
			}
		}

        protected function getFaultMessage(faultEvent:FaultEvent) : String {
			return faultEvent.fault.faultString;
		}
		
		protected function createFaultDetail(faultEvent:FaultEvent) : Object {
			var detail:Object = {};
			detail.command = getQualifiedClassName(this);
			detail.fault = faultEvent.fault;
			detail.totalMemory = System.totalMemory;
			detail.currentTarget = faultEvent.currentTarget;
			return detail;
		}

        protected function handleServerUnavailable(f:FaultEvent) : void {
            TrackingModelLocator.getInstance().disconnectionFault = f.fault;
            TrackingModelLocator.getInstance().disconnected = true;
        }

        protected function handleServerError(f:FaultEvent) : void {
			if (TrackingModelLocator.getInstance().appName == TrackingModelLocator.APP_NAME_BIGBOARD) {
				reloadBoard();
			} else {
            	ErrorDialog.fatal(getFaultMessage(f), createFaultDetail(f));  // sign of a unknown server-side error
			}
        }

        protected function handleUnknownError(f:FaultEvent) : void {
			if (TrackingModelLocator.getInstance().appName == TrackingModelLocator.APP_NAME_BIGBOARD) {
				reloadBoard();
			} else {
            	ErrorDialog.show(getFaultMessage(f), createFaultDetail(f));	// default is non-fatal
			}
        }

        private function isLoginPage(result:String):Boolean {
            return result.indexOf("<TITLE>Login Page</TITLE>") != -1;
        }

        private function attemptLogin():void {
            ClearUnsavedViewsModelEvent.dispatchClearUnsavedViews();
		  	var request: URLRequest = new URLRequest(TrackingModelLocator.getInstance().rootURL);
		    navigateToURL(request, "_top");
        }

		private function reloadBoard():void {
			if (TrackingModelLocator.getInstance().reloadFunction != null)
				TrackingModelLocator.getInstance().reloadFunction.call(null);
		}
    }
}