/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.cci;

import gov.va.med.crypto.VistaKernelHash;
import gov.va.med.crypto.VistaKernelHashCountLimitExceededException;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionSpecImpl;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VistaLinkCcowConnectionSpec
extends VistaLinkConnectionSpecImpl {
    private static final String TYPE_CCOW = "ccow";
    private static final String ELEMENT_CCOW = "KernelCcowToken";
    private static final String ATTRIBUTE_CCOW = "kernelCcowToken";
    private String kernelCcowToken;
    private static Logger logger = Logger.getLogger((Class)(class$gov$va$med$vistalink$adapter$cci$VistaLinkCcowConnectionSpec == null ? (class$gov$va$med$vistalink$adapter$cci$VistaLinkCcowConnectionSpec = VistaLinkCcowConnectionSpec.class$("gov.va.med.vistalink.adapter.cci.VistaLinkCcowConnectionSpec")) : class$gov$va$med$vistalink$adapter$cci$VistaLinkCcowConnectionSpec));
    static /* synthetic */ Class class$gov$va$med$vistalink$adapter$cci$VistaLinkCcowConnectionSpec;

    public VistaLinkCcowConnectionSpec() {
    }

    public VistaLinkCcowConnectionSpec(String encryptedKernelCcowToken) {
        super("");
        this.kernelCcowToken = "";
        try {
            this.kernelCcowToken = VistaKernelHash.encrypt((String)encryptedKernelCcowToken, (boolean)true);
        }
        catch (VistaKernelHashCountLimitExceededException e) {
            logger.error((Object)"Could not encrypt CCOW token", (Throwable)e);
        }
    }

    public ArrayList getProprietarySecurityInfo() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.kernelCcowToken);
        return values;
    }

    public void setAuthenticationNodes(Document requestDoc, Node securityNode) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"setAuthenticationNodes -> Re Auth type is 'ccow'");
        }
        this.setSecurityDivisionAttr(securityNode);
        this.setSecurityTypeAttr(securityNode);
        Element elemCCOW = requestDoc.createElement(ELEMENT_CCOW);
        CDATASection cdata = requestDoc.createCDATASection(this.kernelCcowToken);
        Node currentCcowCdataNode = elemCCOW.getFirstChild();
        if (currentCcowCdataNode != null) {
            elemCCOW.removeChild(currentCcowCdataNode);
        }
        elemCCOW.appendChild(cdata);
        securityNode.appendChild(elemCCOW);
    }

    public boolean isConnSpecEqual(Object obj) {
        return this.equals(obj);
    }

    public boolean equals(Object obj) {
        VistaLinkCcowConnectionSpec connSpec;
        return obj instanceof VistaLinkCcowConnectionSpec && (connSpec = (VistaLinkCcowConnectionSpec)obj).getDivision().equals(this.getDivision()) && connSpec.getKernelCcowToken().equals(this.getKernelCcowToken());
    }

    public int hashCode() {
        int HASHCODE_SEED;
        int returnVal = HASHCODE_SEED = 17;
        int divisionHashCode = this.getDivision().hashCode();
        returnVal = 37 * returnVal + divisionHashCode;
        int kernelTokenHashCode = this.getKernelCcowToken().hashCode();
        returnVal = 37 * returnVal + kernelTokenHashCode;
        return returnVal;
    }

    public String getKernelCcowToken() {
        return this.kernelCcowToken;
    }

    protected void setKernelCcowToken(String kernelCcowToken) {
        this.kernelCcowToken = kernelCcowToken;
    }

    public String getSecurityType() {
        return TYPE_CCOW;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

