/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.rpc;

import gov.va.med.crypto.VistaKernelHash;
import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionSpecImpl;
import gov.va.med.vistalink.adapter.record.VistaLinkRequestVOImpl;
import gov.va.med.vistalink.adapter.spi.EMAdapterEnvironment;
import gov.va.med.vistalink.adapter.spi.EMReAuthState;
import gov.va.med.vistalink.rpc.RpcReferenceType;
import gov.va.med.vistalink.rpc.RpcRequestParam;
import gov.va.med.vistalink.rpc.RpcRequestParams;
import gov.va.med.vistalink.rpc.RpcXmlRequestFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RpcRequest
extends VistaLinkRequestVOImpl {
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$vistalink$rpc$RpcRequest == null ? (class$gov$va$med$vistalink$rpc$RpcRequest = RpcRequest.class$("gov.va.med.vistalink.rpc.RpcRequest")) : class$gov$va$med$vistalink$rpc$RpcRequest));
    private static final char MULTIPLE_M_SUBSRCIPT_FLAG = '\r';
    private static final String VISTALINK_VERSION = "1.5";
    protected static final String RPC_HANDLER_VERSION = "1.5";
    private static final String SINK_NAME = "XOB RPC";
    private static final String SINK_PAD = "00000";
    private static final int SINK_PAD_LEN = "00000".length();
    private boolean useProprietaryMessageFormat = true;
    private boolean debuggingOn = false;
    private RpcRequestParams params;
    private String rpcName;
    private int rpcClientTimeOut;
    private double rpcVersion = 0.0;
    private String rpcContext;
    private String rpcContextEncrypted;
    private boolean xmlResponse = false;
    private VistaLinkConnectionSpecImpl vlConnSpec;
    private EMAdapterEnvironment adapterEnvironment;
    private StringBuffer requestStrBuf = new StringBuffer(200);
    static /* synthetic */ Class class$gov$va$med$vistalink$rpc$RpcRequest;

    protected RpcRequest(String rpcContext, String rpcName) throws FoundationsException {
        super(null);
        this.rpcContext = rpcContext;
        this.rpcName = rpcName;
        this.params = new RpcRequestParams();
    }

    public RpcRequestParams getParams() {
        return this.params;
    }

    public void setParams(List list) {
        for (int item = 0; item < list.size(); ++item) {
            Object obj = list.get(item);
            if (obj instanceof Map || obj instanceof Collection) {
                this.params.setParam(item + 1, "array", obj);
                continue;
            }
            if (obj instanceof RpcReferenceType) {
                this.params.setParam(item + 1, "ref", obj);
                continue;
            }
            this.params.setParam(item + 1, "string", obj);
        }
    }

    public static String buildMultipleMSubscriptKey(String keyValue) {
        return '\r' + keyValue;
    }

    public void clearParams() {
        this.params.clear();
    }

    public String getRpcName() {
        return this.rpcName;
    }

    public void setRpcName(String value) {
        this.rpcName = value;
    }

    public String getRpcContext() {
        return this.rpcContext;
    }

    public void setRpcContext(String value) {
        this.rpcContext = value;
    }

    public int getRpcClientTimeOut() {
        return this.rpcClientTimeOut;
    }

    public void setRpcClientTimeOut(int value) {
        this.rpcClientTimeOut = value;
    }

    public double getRpcVersion() {
        return this.rpcVersion;
    }

    public void setRpcVersion(double value) {
        this.rpcVersion = value;
    }

    public String getRequestString() throws FoundationsException {
        EMReAuthState evaluatedAuthState;
        if (!this.isUseProprietaryMessageFormat()) {
            return RpcXmlRequestFactory.getRpcXmlRequest(this).getRequestString();
        }
        this.requestStrBuf.delete(0, this.requestStrBuf.length());
        String lenSinkName = String.valueOf(SINK_NAME.length());
        this.requestStrBuf.append("00".substring(0, 2 - lenSinkName.length()) + lenSinkName + SINK_NAME);
        if (this.debuggingOn) {
            this.requestStrBuf.append("1");
        } else {
            this.requestStrBuf.append("0");
        }
        this.requestStrBuf.append(SINK_PAD_LEN);
        this.append("VLV", this.convert("1.5"));
        this.append("RHV", this.convert("1.5"));
        this.append("RPV", this.convert(String.valueOf(this.rpcVersion)));
        this.append("RPC", this.convert(this.rpcName));
        try {
            this.append("RCX", this.convert(VistaKernelHash.encrypt((String)this.rpcContext, (boolean)true)));
        }
        catch (FoundationsException e) {
            String errStr = "Can not encrypt rpcContext to be set to RCX.";
            if (logger.isEnabledFor(Priority.ERROR)) {
                logger.error((Object)(errStr + "\n\t" + ExceptionUtils.getFullStackTrace((Throwable)e)));
            }
            throw new FoundationsException(errStr, (Throwable)e);
        }
        this.append("RTO", this.convert(this.rpcClientTimeOut));
        if (this.adapterEnvironment.equals(EMAdapterEnvironment.J2EE)) {
            this.append("SEC", this.convert(this.vlConnSpec.getSecurityType()));
            this.append("DIV", this.convert(this.vlConnSpec.getDivision()));
            evaluatedAuthState = this.vlConnSpec.getSecurityState();
            this.append("RAS", this.convert(evaluatedAuthState.toString()));
            if (!evaluatedAuthState.equals(EMReAuthState.AUTHENTICATED)) {
                ArrayList values = this.vlConnSpec.getProprietarySecurityInfo();
                Iterator valueIter = values.iterator();
                while (valueIter.hasNext()) {
                    this.append("RAS", this.convert((String)valueIter.next()));
                }
            }
        } else if (this.adapterEnvironment.equals(EMAdapterEnvironment.J2SE)) {
            this.append("SEC", this.convert(this.vlConnSpec.getSecurityType()));
            this.append("DIV", this.convert(""));
            evaluatedAuthState = EMReAuthState.AUTHENTICATED;
            this.append("RAS", this.convert(evaluatedAuthState.toString()));
        }
        int paramCount = this.params.getParams().size();
        RpcRequestParam param = null;
        Object value = null;
        this.append("PMS", this.convert(paramCount));
        for (int i = 0; i < paramCount; ++i) {
            String position = String.valueOf(i + 1);
            if (!this.params.getParams().containsKey(position)) continue;
            param = (RpcRequestParam)this.params.getParams().get(position);
            value = param.getValue();
            if (value instanceof Map) {
                this.doMap((Map)value, position);
                continue;
            }
            if (value instanceof Set) {
                this.doCollection((Set)value, position);
                continue;
            }
            if (value instanceof List) {
                this.doCollection((List)value, position);
                continue;
            }
            this.append("TYP", this.convert(param.getType()));
            this.append("POS", this.convert(position));
            this.append("VAL", this.convert(value.toString()));
        }
        return this.requestStrBuf.toString();
    }

    private void doMap(Map value, String position) {
        this.append("TYP", this.convert("array"));
        this.append("POS", this.convert(position));
        this.append("ITS", this.convert(value.size()));
        Iterator it = value.entrySet().iterator();
        Object subscript = null;
        Object subscriptValue = null;
        while (it.hasNext()) {
            Map.Entry me = it.next();
            this.append("SUB", this.convert(me.getKey().toString()));
            this.append("VAL", this.convert(me.getValue().toString()));
        }
    }

    private void doCollection(Collection value, String position) {
        this.append("TYP", this.convert("array"));
        this.append("POS", this.convert(position));
        this.append("ITS", this.convert(value.size()));
        int item = 0;
        Iterator it = value.iterator();
        while (it.hasNext()) {
            this.append("SUB", this.convert(String.valueOf(++item)));
            this.append("VAL", this.convert(it.next().toString()));
        }
    }

    private void append(String label, String value) {
        if (this.debuggingOn) {
            this.requestStrBuf.append(label).append("=").append(value);
        } else {
            this.requestStrBuf.append(value);
        }
    }

    private String convert(String str) {
        String lenStr = String.valueOf(str.length());
        return SINK_PAD.substring(0, SINK_PAD_LEN - lenStr.length()) + lenStr + str;
    }

    private String convert(int cnt) {
        String lenStr = String.valueOf(String.valueOf(cnt).length());
        return SINK_PAD.substring(0, SINK_PAD_LEN - lenStr.length()) + lenStr + cnt;
    }

    public boolean isXmlResponse() {
        return this.xmlResponse;
    }

    public void setXmlResponse(boolean value) {
        this.xmlResponse = value;
    }

    public boolean isUseProprietaryMessageFormat() {
        return this.useProprietaryMessageFormat;
    }

    public void setUseProprietaryMessageFormat(boolean useSink) {
        this.useProprietaryMessageFormat = useSink;
    }

    public void setReAuthenticateInfo(VistaLinkConnectionSpecImpl connSpec, EMReAuthState reAuthState, EMAdapterEnvironment theAdapterEnvironment) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting re-authentication information");
        }
        this.adapterEnvironment = theAdapterEnvironment;
        this.vlConnSpec = null;
        if (connSpec != null) {
            this.vlConnSpec = connSpec;
            this.vlConnSpec.setSecurityState(reAuthState);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"the conn spec is null!!!");
        }
    }

    EMAdapterEnvironment getAdapterEnvironment() {
        return this.adapterEnvironment;
    }

    VistaLinkConnectionSpecImpl getVlConnSpec() {
        return this.vlConnSpec;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

