/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.rpc;

import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.record.LoginsDisabledFaultException;
import gov.va.med.vistalink.adapter.record.VistaLinkFaultException;
import gov.va.med.vistalink.adapter.record.VistaLinkRequestVO;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseFactoryImpl;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseVO;
import gov.va.med.vistalink.rpc.NoRpcContextFaultException;
import gov.va.med.vistalink.rpc.RpcFaultException;
import gov.va.med.vistalink.rpc.RpcNotInContextFaultException;
import gov.va.med.vistalink.rpc.RpcNotOkForProxyUseException;
import gov.va.med.vistalink.rpc.RpcRequest;
import gov.va.med.vistalink.rpc.RpcResponse;
import gov.va.med.vistalink.rpc.RpcTimeOutFaultException;
import gov.va.med.vistalink.security.m.SecurityAccessVerifyCodePairInvalidException;
import gov.va.med.vistalink.security.m.SecurityDivisionDeterminationFaultException;
import gov.va.med.vistalink.security.m.SecurityFaultException;
import gov.va.med.vistalink.security.m.SecurityIdentityDeterminationFaultException;
import gov.va.med.vistalink.security.m.SecurityTooManyInvalidLoginAttemptsFaultException;
import gov.va.med.vistalink.security.m.SecurityUserAuthorizationException;
import gov.va.med.vistalink.security.m.SecurityUserVerifyCodeException;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RpcResponseFactory
extends VistaLinkResponseFactoryImpl {
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$vistalink$rpc$RpcResponseFactory == null ? (class$gov$va$med$vistalink$rpc$RpcResponseFactory = RpcResponseFactory.class$("gov.va.med.vistalink.rpc.RpcResponseFactory")) : class$gov$va$med$vistalink$rpc$RpcResponseFactory));
    protected static final String GOV_VA_MED_RPC_RESPONSE = "gov.va.med.foundations.rpc.response";
    protected static final String GOV_VA_MED_RPC_FAULT = "gov.va.med.foundations.rpc.fault";
    protected static final String ERROR_MSG_RPC = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><VistaLink messageType=\"gov.va.med.foundations.rpc.fault";
    protected static final String CDATA_BEG = "<![CDATA[";
    protected static final String CDATA_END_W_SUFFIX = "]]></Response></VistaLink>";
    protected static final String CDATA_END_WO_SUFFIX = "]]>";
    protected static final String MOST_COMMON_HEADER = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><VistaLink messageType=\"gov.va.med.foundations.rpc.response\" version=\"1.5\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"rpcResponse.xsd\"><Response type=\"";
    protected static final String MOST_COMMON_MIDDLE = "\" ><![CDATA[";
    protected static final String MOST_COMMON_ENDING = "]]></Response></VistaLink>";
    static /* synthetic */ Class class$gov$va$med$vistalink$rpc$RpcResponseFactory;

    public VistaLinkResponseVO handleResponse(String response, VistaLinkRequestVO requestVO) throws FoundationsException {
        VistaLinkResponseVO result = this.handleCommonCase(response, requestVO);
        if (result != null) {
            return result;
        }
        return super.handleResponse(response, requestVO);
    }

    private VistaLinkResponseVO handleCommonCase(String response, VistaLinkRequestVO requestVO) {
        if (!response.startsWith(MOST_COMMON_HEADER)) {
            return null;
        }
        if (!response.endsWith("]]></Response></VistaLink>")) {
            return null;
        }
        int mid = response.indexOf(MOST_COMMON_MIDDLE, MOST_COMMON_HEADER.length());
        if (mid == -1) {
            return null;
        }
        String type = response.substring(MOST_COMMON_HEADER.length(), mid);
        int resultStart = mid + MOST_COMMON_MIDDLE.length();
        int resultEnd = response.length() - "]]></Response></VistaLink>".length();
        String rpcResult = response.substring(resultStart, resultEnd);
        RpcResponse rpcResponse = new RpcResponse(response, response, null, GOV_VA_MED_RPC_RESPONSE, rpcResult, type);
        RpcRequest rpcRequest = (RpcRequest)requestVO;
        if (rpcRequest.isXmlResponse()) {
            rpcResponse.setResultsType("xml");
        }
        return rpcResponse;
    }

    protected VistaLinkResponseVO parseMessageBody(String rawXml, String filteredXml, Document doc, String messageType, VistaLinkRequestVO requestVO) throws FoundationsException {
        Node resultsNode;
        String cdataFromXml = this.getCDATAFromResponseXml(rawXml);
        String resultsType = null;
        if (messageType.equals(GOV_VA_MED_RPC_RESPONSE)) {
            DOMXPath xpath = null;
            resultsNode = null;
            try {
                xpath = new DOMXPath("/VistaLink/Response/.");
                resultsNode = (Node)xpath.selectSingleNode((Object)doc);
            }
            catch (JaxenException e) {
                String errStr = "Exception occured getting Response DOM node from response XML document.";
                if (logger.isEnabledFor(Priority.ERROR)) {
                    logger.error((Object)(errStr + "\n\t" + ExceptionUtils.getFullStackTrace((Throwable)e)));
                }
                throw new FoundationsException(errStr, (Throwable)e);
            }
        } else {
            throw new FoundationsException("Illegal Response Format Returned: '" + messageType + "'.");
        }
        NamedNodeMap attrs = resultsNode.getAttributes();
        Attr attr = (Attr)attrs.getNamedItem("type");
        resultsType = attr.getValue().toLowerCase();
        RpcResponse rpcResponse = new RpcResponse(rawXml, filteredXml, doc, messageType, cdataFromXml, resultsType);
        RpcRequest rpcRequest = (RpcRequest)requestVO;
        if (rpcRequest.isXmlResponse()) {
            rpcResponse.setResultsType("xml");
        }
        return rpcResponse;
    }

    protected boolean doesResponseIndicateFault(String rawXml) {
        return rawXml.startsWith(ERROR_MSG_RPC);
    }

    protected String filterResponseXmlString(String rawXml, boolean isFault) {
        return this.removeCDATAFromResponseXml(rawXml, isFault);
    }

    private String removeCDATAFromResponseXml(String rawXml, boolean isFault) {
        int cdataIndex = this.getCDATAStartIndex(rawXml);
        if (cdataIndex > -1 && !isFault) {
            String xmlNoCData = rawXml.substring(0, cdataIndex) + "</Response></VistaLink>";
            return xmlNoCData;
        }
        return rawXml;
    }

    private String getCDATAFromResponseXml(String rawXml) {
        int cdataStartIndex = this.getCDATAStartIndex(rawXml);
        String retStr = null;
        if (cdataStartIndex > -1) {
            int cdataEndIndex = this.getCDATAEndIndex(rawXml);
            retStr = rawXml.substring(cdataStartIndex + CDATA_BEG.length(), cdataEndIndex);
        }
        return retStr;
    }

    private int getCDATAStartIndex(String rawXml) {
        return rawXml.indexOf(CDATA_BEG);
    }

    private int getCDATAEndIndex(String rawXml) {
        return rawXml.indexOf("]]></Response></VistaLink>");
    }

    protected VistaLinkFaultException handleSpecificFault(Document xdoc, String messageType, VistaLinkFaultException faultException) throws VistaLinkFaultException, FoundationsException {
        if ("181004".equals(faultException.getErrorCode())) {
            return new LoginsDisabledFaultException(faultException);
        }
        if ("182005".equals(faultException.getErrorCode())) {
            return new RpcNotInContextFaultException(faultException);
        }
        if ("182006".equals(faultException.getErrorCode())) {
            return new NoRpcContextFaultException(faultException);
        }
        if ("182007".equals(faultException.getErrorCode())) {
            return new RpcTimeOutFaultException(faultException);
        }
        if ("182010".equals(faultException.getErrorCode())) {
            return new RpcNotOkForProxyUseException(faultException);
        }
        if ("182301".equals(faultException.getErrorCode())) {
            return new SecurityIdentityDeterminationFaultException(faultException);
        }
        if ("182302".equals(faultException.getErrorCode())) {
            return new SecurityDivisionDeterminationFaultException(faultException);
        }
        if ("182303".equals(faultException.getErrorCode())) {
            return new SecurityUserVerifyCodeException(faultException);
        }
        if ("182304".equals(faultException.getErrorCode())) {
            return new SecurityUserAuthorizationException(faultException);
        }
        if ("182305".equals(faultException.getErrorCode())) {
            return new SecurityAccessVerifyCodePairInvalidException(faultException);
        }
        if ("182306".equals(faultException.getErrorCode())) {
            return new SecurityTooManyInvalidLoginAttemptsFaultException(faultException);
        }
        if ("182307".equals(faultException.getErrorCode())) {
            return new SecurityIdentityDeterminationFaultException(faultException);
        }
        if ("182308".equals(faultException.getErrorCode())) {
            return new SecurityDivisionDeterminationFaultException(faultException);
        }
        if ("1823".equals(faultException.getErrorCode().substring(0, 4))) {
            return new SecurityFaultException(faultException);
        }
        if ("182".equals(faultException.getErrorCode().substring(0, 3))) {
            return new RpcFaultException(faultException);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

