/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.cci;

import gov.va.med.environment.Environment;
import gov.va.med.environment.ServerType;
import gov.va.med.exception.ExceptionUtils;
import gov.va.med.vistalink.adapter.cci.JndiVerificationStrategy;
import gov.va.med.vistalink.adapter.cci.JndiVerificationStrategyAlwaysPass;
import gov.va.med.vistalink.adapter.cci.JndiVerificationStrategyWeblogic81;
import gov.va.med.vistalink.adapter.cci.VistaLinkResourceAdapterMetaData;
import gov.va.med.vistalink.adapter.cci.VistaLinkResourceException;
import gov.va.med.vistalink.adapter.spi.ConnectorInfoVO;
import gov.va.med.vistalink.adapter.spi.EMAdapterEnvironment;
import gov.va.med.vistalink.adapter.spi.VistaLinkConnectionManager;
import gov.va.med.vistalink.adapter.spi.VistaLinkConnectionRequestInfo;
import gov.va.med.vistalink.adapter.spi.VistaLinkManagedConnectionFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.naming.Reference;
import javax.resource.NotSupportedException;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class VistaLinkConnectionFactory
implements ConnectionFactory,
Serializable,
Referenceable {
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$vistalink$adapter$cci$VistaLinkConnectionFactory == null ? (class$gov$va$med$vistalink$adapter$cci$VistaLinkConnectionFactory = VistaLinkConnectionFactory.class$("gov.va.med.vistalink.adapter.cci.VistaLinkConnectionFactory")) : class$gov$va$med$vistalink$adapter$cci$VistaLinkConnectionFactory));
    private static JndiVerificationStrategy jndiVerificationStrategy = null;
    private ManagedConnectionFactory managedFactory;
    private ConnectionManager connectionManager;
    private Reference reference;
    private PrintWriter printWriter;
    private boolean passedJndiMismatchCheck = false;
    private int getConnectionWrongModeInvocationCount = 0;
    private EMAdapterEnvironment adapterEnvironment;
    static /* synthetic */ Class class$gov$va$med$vistalink$adapter$cci$VistaLinkConnectionFactory;

    public VistaLinkConnectionFactory(VistaLinkManagedConnectionFactory managedFactory, ConnectionManager connectionManager) {
        this.managedFactory = managedFactory;
        this.adapterEnvironment = managedFactory.getAdapterEnvironment();
        logger.debug((Object)"VistaLinkConnectionFactory constructor called!");
        this.connectionManager = connectionManager == null ? new VistaLinkConnectionManager() : connectionManager;
        this.reference = null;
        this.printWriter = null;
    }

    private Connection allocateConnection() throws ResourceException {
        if (this.managedFactory == null) {
            throw new ResourceAdapterInternalException("managedConnectionFactory is not set for this connectionFactory");
        }
        return (Connection)this.connectionManager.allocateConnection(this.managedFactory, null);
    }

    private Connection allocateConnection(ConnectionRequestInfo cri) throws ResourceException {
        if (this.managedFactory == null) {
            throw new ResourceAdapterInternalException("managedConnectionFactory is not set for this connectionFactory");
        }
        return (Connection)this.connectionManager.allocateConnection(this.managedFactory, cri);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.printWriter;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.printWriter = printWriter;
    }

    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        return new VistaLinkResourceAdapterMetaData();
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Connection getConnection(ConnectionSpec connectionSpec) throws ResourceException {
        try {
            if (this.adapterEnvironment.equals(EMAdapterEnvironment.J2SE)) {
                throw new VistaLinkResourceException("Use of this method is not allowed in a J2SE environment, please use getConnection() instead");
            }
            if (this.adapterEnvironment.equals(EMAdapterEnvironment.J2EE) && !this.isPassedJndiMismatchCheck()) {
                if (!jndiVerificationStrategy.checkJndiMismatch((VistaLinkManagedConnectionFactory)this.managedFactory, this)) {
                    String errorMessage = "JNDI Mismatch found for connector configured with JNDI Name: '" + (this.managedFactory == null ? "[not defined]" : ((VistaLinkManagedConnectionFactory)this.managedFactory).getConnectorJndiName()) + "'. Rejecting connection request.";
                    logger.error((Object)errorMessage);
                    throw new VistaLinkResourceException(errorMessage);
                }
                this.setPassedJndiMismatchCheck(true);
            }
            return this.allocateConnection(new VistaLinkConnectionRequestInfo(connectionSpec));
        }
        catch (ResourceException e) {
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = "Can not allocate VistaLinkConnection." + "\n\t" + ExceptionUtils.getFullStackTrace((Throwable)e);
                logger.error((Object)errMsg);
            }
            throw e;
        }
    }

    public Connection getConnection() throws ResourceException {
        if (this.adapterEnvironment.equals(EMAdapterEnvironment.J2EE)) {
            String errMsg = "Use of this method is not allowed in a J2EE environment, please use getConnection(ConnectionSpec) instead. NOTE: IF this is exception is logged during connector deployment or startup on BEA WebLogic, one instance of this exception per connector module is always thrown. This is normal and can be ignored in those cases.";
            ++this.getConnectionWrongModeInvocationCount;
            if (Environment.getServerType().equals(ServerType.WEBLOGIC) && this.getConnectionWrongModeInvocationCount < 2) {
                logger.debug((Object)errMsg);
            } else {
                logger.error((Object)errMsg);
            }
            throw new VistaLinkResourceException(errMsg);
        }
        try {
            return this.allocateConnection();
        }
        catch (ResourceException e) {
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = "Can not allocate VistaLinkConnection." + "\n\t" + ExceptionUtils.getFullStackTrace((Throwable)e);
                logger.error((Object)errMsg);
            }
            throw e;
        }
    }

    public RecordFactory getRecordFactory() throws ResourceException {
        throw new NotSupportedException("getRecordFactory() is not supported at this time.");
    }

    public static final VistaLinkConnectionFactory getVistaLinkConnectionFactory(String hostIPAddress, Integer hostPort) throws ResourceException {
        try {
            VistaLinkManagedConnectionFactory mcf = new VistaLinkManagedConnectionFactory();
            mcf.setNonManagedHostIPAddress(hostIPAddress);
            mcf.setNonManagedHostPort(hostPort);
            mcf.setAdapterEnvironment(EMAdapterEnvironment.J2SE);
            return (VistaLinkConnectionFactory)mcf.createConnectionFactory();
        }
        catch (ResourceException e) {
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = "Can not create VistaLinkConnectionFactory." + "\n\t" + ExceptionUtils.getFullStackTrace((Throwable)e);
                logger.error((Object)errMsg);
            }
            throw e;
        }
    }

    private synchronized boolean isPassedJndiMismatchCheck() {
        return this.passedJndiMismatchCheck;
    }

    private synchronized void setPassedJndiMismatchCheck(boolean passedJndiMismatchCheck) {
        this.passedJndiMismatchCheck = passedJndiMismatchCheck;
    }

    public void getMCFInfo(ConnectorInfoVO connectorInfoVO, boolean getDetailInfo) {
        if (this.managedFactory != null) {
            VistaLinkManagedConnectionFactory mcf = (VistaLinkManagedConnectionFactory)this.managedFactory;
            connectorInfoVO.setCfgIpAddress(mcf.getHostIpAddressUnresolved());
            connectorInfoVO.setCfgPort(mcf.getHostPort());
            connectorInfoVO.setHlthConnectionAuthFailureCount(mcf.getConnectionAuthFailureCount());
            connectorInfoVO.setHlthConnectionFailureCount(mcf.getConnectionFailureCount());
            connectorInfoVO.setHlthDivisionMismatchCount(mcf.getDivisionMismatchCount());
            connectorInfoVO.setHlthIdentityFailureCount(mcf.getIdentityFailureCount());
            connectorInfoVO.setHlthProductionMismatchCount(mcf.getProductionMismatchCount());
            connectorInfoVO.setCfgTimeout(new Long(mcf.getDefaultJ2EETimeOut() / 1000L).intValue());
            connectorInfoVO.setCfgTimeoutAlwaysUseDefaultAsMin(mcf.isAlwaysUseDefaultAsMin());
            if (getDetailInfo) {
                connectorInfoVO.setPerfCreateConnectionHandleAvgMillis(mcf.getCreateConnectionHandleAvgMillis());
                connectorInfoVO.setPerfMatchManagedConnectionAvgMillis(mcf.getMatchManagedConnectionAvgMillis());
                connectorInfoVO.setVljDistinguishedIdentifier(mcf.getDistinguishedIdentifier());
                connectorInfoVO.setMSystemInfo(mcf.getSystemInfo());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        jndiVerificationStrategy = Environment.getServerType().equals(ServerType.WEBLOGIC) ? new JndiVerificationStrategyWeblogic81() : new JndiVerificationStrategyAlwaysPass();
    }
}

