/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.net;

import gov.va.med.exception.ExceptionUtils;
import gov.va.med.net.VistaSocketException;
import gov.va.med.net.VistaSocketTimeOutException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SocketManager
implements Serializable {
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$net$SocketManager == null ? (class$gov$va$med$net$SocketManager = SocketManager.class$("gov.va.med.net.SocketManager")) : class$gov$va$med$net$SocketManager));
    private Socket soc;
    private String matchingIdentifier;
    private int bufferSize = 512;
    private static final char EOT = '\u0004';
    private static final String ENCODE_OUTF8 = "UTF8";
    private static final String ENCODE_ASCII = "US-ASCII";
    private static final String ENCODE_CP1252 = "Cp1252";
    static /* synthetic */ Class class$gov$va$med$net$SocketManager;

    public SocketManager() {
    }

    public SocketManager(Socket soc) {
        this.setSoc(soc);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int value) {
        this.bufferSize = value;
    }

    public Socket getSoc() {
        return this.soc;
    }

    public void setSoc(Socket value) {
        this.soc = value;
    }

    public void sendData(String xmlRequest) throws VistaSocketException {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(this.soc.getOutputStream(), ENCODE_CP1252), this.soc.getSendBufferSize());
            out.write(xmlRequest + '\u0004');
            out.flush();
        }
        catch (Exception e) {
            throw new VistaSocketException("Error occurred writing to socket.", e);
        }
    }

    public String receiveData() throws VistaSocketException, VistaSocketTimeOutException {
        StringBuffer sb = new StringBuffer();
        char[] buffer = new char[this.bufferSize];
        boolean moreData = true;
        int dataRead = 0;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.soc.getInputStream(), ENCODE_CP1252), this.soc.getReceiveBufferSize());
            while (moreData) {
                dataRead = in.read(buffer);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)this.getLoggerFormattedString("read data->" + dataRead));
                }
                if (dataRead > 0) {
                    if (buffer[dataRead - 1] == '\u0004') {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)this.getLoggerFormattedString("read data->Got EOT->" + dataRead));
                        }
                        moreData = false;
                        sb.append(buffer, 0, dataRead - 1);
                        continue;
                    }
                    sb.append(buffer, 0, dataRead);
                    continue;
                }
                if (dataRead == -1) {
                    moreData = false;
                    throw new VistaSocketException("End of stream encountered unexpectedly.");
                }
                moreData = false;
                throw new VistaSocketException("BufferedReader.read() returned " + dataRead);
            }
        }
        catch (Exception e) {
            if (logger.isEnabledFor(Priority.ERROR)) {
                if (dataRead > buffer.length - 1 | dataRead < 1) {
                    logger.error((Object)this.getLoggerFormattedStringWStackTrace("receiving data exception-> dataRead value: " + dataRead, e));
                } else {
                    logger.error((Object)this.getLoggerFormattedStringWStackTrace(new StringBuffer().append("receiving data exception->").append(buffer, 0, dataRead).toString(), e));
                }
            }
            String timeoutStr = null;
            try {
                timeoutStr = "Socket Timeout occured. Timeout setting was: '" + Integer.toString(this.soc.getSoTimeout()) + " ms'. ";
            }
            catch (Exception e1) {
                timeoutStr = "Socket Timeout occured. Unable to determine timeout setting. ";
            }
            String SOCKET_TIMEOUT_EXCEPTION_CLASS_1_3_1 = "java.io.InterruptedIOException";
            String SOCKET_TIMEOUT_EXCEPTION_CLASS_1_4_1 = "java.net.SocketTimeoutException";
            if (e.getClass().getName().equals(SOCKET_TIMEOUT_EXCEPTION_CLASS_1_4_1)) {
                throw new VistaSocketTimeOutException(timeoutStr, e);
            }
            if (e.getClass().getName().equals(SOCKET_TIMEOUT_EXCEPTION_CLASS_1_3_1)) {
                throw new VistaSocketTimeOutException(timeoutStr, e);
            }
            throw new VistaSocketException("Error occurred reading from socket. ", e);
        }
        return sb.toString();
    }

    public String getMatchingIdentifier() {
        return this.matchingIdentifier;
    }

    public void setMatchingIdentifier(String string) {
        this.matchingIdentifier = string;
    }

    public String toString() {
        return this.getClass().getName() + "[mdi]" + this.getMatchingIdentifier();
    }

    private String getLoggerFormattedString(String log) {
        return this.toString() + "\n\t" + log;
    }

    private String getLoggerFormattedStringWStackTrace(Throwable e) {
        return this.getLoggerFormattedString(ExceptionUtils.getFullStackTrace(e));
    }

    private String getLoggerFormattedStringWStackTrace(String log, Throwable e) {
        return this.getLoggerFormattedString(log + "\n\t" + ExceptionUtils.getFullStackTrace(e));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

