/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.heartbeat;

import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.heartbeat.VistaHeartBeatTimerResponse;
import gov.va.med.vistalink.adapter.record.VistaLinkRequestVO;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseFactoryImpl;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseVO;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class VistaHeartBeatTimerResponseFactory
extends VistaLinkResponseFactoryImpl {
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$vistalink$adapter$heartbeat$VistaHeartBeatTimerResponseFactory == null ? (class$gov$va$med$vistalink$adapter$heartbeat$VistaHeartBeatTimerResponseFactory = VistaHeartBeatTimerResponseFactory.class$("gov.va.med.vistalink.adapter.heartbeat.VistaHeartBeatTimerResponseFactory")) : class$gov$va$med$vistalink$adapter$heartbeat$VistaHeartBeatTimerResponseFactory));
    static /* synthetic */ Class class$gov$va$med$vistalink$adapter$heartbeat$VistaHeartBeatTimerResponseFactory;

    protected VistaLinkResponseVO parseMessageBody(String rawXml, String filteredXml, Document doc, String messageType, VistaLinkRequestVO requestVO) throws FoundationsException {
        try {
            boolean heartBeatSuccessful;
            long heartBeatRateMillis = 0L;
            DOMXPath xpath = new DOMXPath("/VistaLink/Response/.");
            Node resultsNode = (Node)xpath.selectSingleNode((Object)doc);
            NamedNodeMap attrs = resultsNode.getAttributes();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"got response attributes");
            }
            boolean bl = heartBeatSuccessful = ((Attr)attrs.getNamedItem("type")).getValue().equals("heartbeat") && ((Attr)attrs.getNamedItem("status")).getValue().equals("success");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"got heart beat success");
            }
            heartBeatRateMillis = 1000L * Long.parseLong(((Attr)attrs.getNamedItem("rate")).getValue());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"got heart beat rate millis");
            }
            return new VistaHeartBeatTimerResponse(rawXml, filteredXml, doc, messageType, heartBeatSuccessful, heartBeatRateMillis);
        }
        catch (JaxenException e) {
            String errStr = "could not parse xml";
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = errStr + "\n\t" + ExceptionUtils.getFullStackTrace((Throwable)e);
                logger.error((Object)errMsg);
            }
            throw new FoundationsException(errStr, (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

