/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.spi;

import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.adapter.cci.VistaLinkResourceException;
import gov.va.med.vistalink.adapter.record.VistaLinkFaultException;
import gov.va.med.vistalink.adapter.record.VistaLinkRequestVO;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseFactory;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseVO;
import gov.va.med.vistalink.adapter.spi.VistaLinkManagedConnection;
import gov.va.med.vistalink.adapter.spi.VistaLinkServerInfo;
import gov.va.med.vistalink.rpc.RpcRequest;
import gov.va.med.vistalink.rpc.RpcResponse;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class VistaLinkConnectionImpl
implements VistaLinkConnection {
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$vistalink$adapter$cci$VistaLinkConnection == null ? (class$gov$va$med$vistalink$adapter$cci$VistaLinkConnection = VistaLinkConnectionImpl.class$("gov.va.med.vistalink.adapter.cci.VistaLinkConnection")) : class$gov$va$med$vistalink$adapter$cci$VistaLinkConnection));
    private VistaLinkManagedConnection managedConnection;
    static /* synthetic */ Class class$gov$va$med$vistalink$adapter$cci$VistaLinkConnection;

    public VistaLinkConnectionImpl(VistaLinkManagedConnection mc) {
        this.managedConnection = mc;
    }

    public void close() throws ResourceException {
        try {
            if (this.managedConnection != null) {
                this.managedConnection.setDefaultSocketTimeOut();
                this.managedConnection.closeHandle(this);
                this.managedConnection = null;
            }
        }
        catch (ResourceException e) {
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = "Can not close connection handle." + "\n\t" + ExceptionUtils.getFullStackTrace((Throwable)e);
                logger.error((Object)errMsg);
            }
            throw e;
        }
    }

    public VistaLinkResponseVO executeInteraction(VistaLinkRequestVO requestVO, VistaLinkResponseFactory responseFactory) throws VistaLinkFaultException, FoundationsException {
        try {
            return this.getManagedConnection().executeInteraction(requestVO, responseFactory);
        }
        catch (VistaLinkFaultException e) {
            throw e;
        }
        catch (FoundationsException e) {
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = "Can not execute interaction." + "\n\t" + ExceptionUtils.getFullStackTrace((Throwable)e);
                logger.error((Object)errMsg);
            }
            throw e;
        }
    }

    public RpcResponse executeRPC(RpcRequest request) throws VistaLinkFaultException, FoundationsException {
        try {
            return this.getManagedConnection().executeRPC(request);
        }
        catch (VistaLinkFaultException e) {
            throw e;
        }
        catch (FoundationsException e) {
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = "Can not execute RPC." + "\n\t" + ExceptionUtils.getFullStackTrace((Throwable)e);
                logger.error((Object)errMsg);
            }
            throw e;
        }
    }

    public int getTimeOut() {
        return new Long(this.managedConnection.getSocketTimeOut()).intValue();
    }

    public void setTimeOut(int timeOut) {
        this.managedConnection.setSocketTimeOut(timeOut);
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        try {
            return this.managedConnection.getConnectionMetaData();
        }
        catch (VistaLinkResourceException e) {
            if (logger.isEnabledFor(Priority.ERROR)) {
                String errMsg = ExceptionUtils.getFullStackTrace((Throwable)((Object)e));
                logger.error((Object)errMsg);
            }
            throw e;
        }
    }

    public VistaLinkServerInfo getConnectionInfo() {
        return new VistaLinkServerInfo(this.managedConnection.getHostAddr(), this.managedConnection.getHostPort());
    }

    public VistaLinkManagedConnection getManagedConnection() throws FoundationsException {
        if (this.managedConnection == null) {
            throw new FoundationsException("The managed connection is null.");
        }
        return this.managedConnection;
    }

    public void setManagedConnection(VistaLinkManagedConnection mc) {
        this.managedConnection = mc;
    }

    public Interaction createInteraction() throws ResourceException {
        throw new NotSupportedException("VistALink does not implement Iteraction and Record part of CCI interface.  VistaRequest interface is used instead.");
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException("VistALink does not support local transactions.");
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        throw new NotSupportedException("VistALink does not support ResultSet functionality.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

