/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.institution;

import gov.va.med.vistalink.adapter.cci.VistaLinkResourceException;
import gov.va.med.vistalink.institution.InstitutionMapNotInitializedException;
import gov.va.med.vistalink.institution.InstitutionMapping;
import gov.va.med.vistalink.institution.InstitutionMappingBadStationNumberException;
import gov.va.med.vistalink.institution.InstitutionMappingFactory;
import gov.va.med.vistalink.institution.InstitutionMappingNotFoundException;
import gov.va.med.vistalink.institution.InstitutionMappingVO;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class InstitutionMappingImpl
implements InstitutionMapping {
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$vistalink$institution$InstitutionMappingImpl == null ? (class$gov$va$med$vistalink$institution$InstitutionMappingImpl = InstitutionMappingImpl.class$("gov.va.med.vistalink.institution.InstitutionMappingImpl")) : class$gov$va$med$vistalink$institution$InstitutionMappingImpl));
    private static InstitutionMappingImpl me = null;
    private TreeMap institutionMap = new TreeMap();
    private static Object syncObjSingleton = new Object();
    private Object syncObjMapping = new Object();
    static /* synthetic */ Class class$gov$va$med$vistalink$institution$InstitutionMappingImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InstitutionMappingImpl getInstance() throws IllegalStateException {
        if (logger.isEnabledFor(Priority.DEBUG)) {
            logger.debug((Object)"InstitutionMappingImpl :: In getInstance().");
        }
        Object object = syncObjSingleton;
        synchronized (object) {
            if (me == null) {
                String errStr = "InstitutionMappingImpl :: Instance does not exist.";
                if (logger.isEnabledFor(Priority.ERROR)) {
                    logger.error((Object)errStr);
                }
                throw new IllegalStateException(errStr);
            }
            return me;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createInstance() throws VistaLinkResourceException {
        if (logger.isEnabledFor(Priority.DEBUG)) {
            logger.debug((Object)"InstitutionMappingImpl :: In createInstance(institutionMap).");
        }
        Object object = syncObjSingleton;
        synchronized (object) {
            if (me == null) {
                if (logger.isEnabledFor(Priority.DEBUG)) {
                    logger.debug((Object)"Instance is null, so creating.");
                }
            } else {
                throw new VistaLinkResourceException("Institution Mapping has been already created.");
            }
            me = new InstitutionMappingImpl();
            InstitutionMappingFactory.registerSingleton(me);
            logger.debug((Object)"Instance created.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean instanceExists() {
        Object object = syncObjSingleton;
        synchronized (object) {
            return me != null;
        }
    }

    private InstitutionMappingImpl() {
        if (logger.isEnabledFor(Priority.DEBUG)) {
            logger.debug((Object)"InstitutionMappingImpl :: In private constructor.");
        }
        this.institutionMap = new TreeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMappingsForJndiName(String mcfJndiName, String[] mcfStationNumbers, long mcfDistinguishedIdentifier) throws InstitutionMappingBadStationNumberException {
        for (int i = 0; i < mcfStationNumbers.length; ++i) {
            InstitutionMappingImpl.checkStationNumber(mcfStationNumbers[i]);
        }
        Object object = this.syncObjMapping;
        synchronized (object) {
            String mappingJndiName;
            Set keySet = this.institutionMap.keySet();
            Iterator iter = keySet.iterator();
            while (iter.hasNext()) {
                String mappingStationNumber = (String)iter.next();
                mappingJndiName = ((InstitutionMappingVO)this.institutionMap.get(mappingStationNumber)).getJndiName();
                if (!mcfJndiName.equals(mappingJndiName)) continue;
                boolean stationMatch = false;
                for (int i = 0; i < mcfStationNumbers.length; ++i) {
                    if (!mcfStationNumbers[i].equals(mappingStationNumber)) continue;
                    stationMatch = true;
                }
                if (stationMatch) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("removing mapping of station number '" + mappingStationNumber + "' to JNDI name '" + mcfJndiName + "'."));
                }
                iter.remove();
            }
            for (int i = 0; i < mcfStationNumbers.length; ++i) {
                logger.debug((Object)("considering station#: " + mcfStationNumbers[i]));
                if (!this.institutionMap.containsKey(mcfStationNumbers[i])) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("adding mapping for JNDI name '" + mcfJndiName + "' to station number '" + mcfStationNumbers[i] + "'."));
                    }
                    this.institutionMap.put(mcfStationNumbers[i], new InstitutionMappingVO(mcfJndiName, mcfDistinguishedIdentifier));
                    continue;
                }
                InstitutionMappingVO foundMapping = (InstitutionMappingVO)this.institutionMap.get(mcfStationNumbers[i]);
                mappingJndiName = foundMapping.getJndiName();
                if (mappingJndiName.equals(mcfJndiName)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Institution mapping contains station number: " + mcfStationNumbers[i] + "and the JNDI names are equal. Updating the last MCF distinguished identifier for mapping."));
                    }
                    foundMapping.setLastOneInMcfDistinguishedIdentifier(mcfDistinguishedIdentifier);
                    continue;
                }
                if (!mappingJndiName.equals(mcfJndiName)) {
                    logger.warn((Object)("Existing station mapping found for station '" + mcfStationNumbers[i] + "' mapped to JNDI name '" + mappingJndiName + "'. Replacing with new mapping to JNDI name '" + mcfJndiName + "'."));
                }
                foundMapping.setJndiName(mcfJndiName);
                foundMapping.setLastOneInMcfDistinguishedIdentifier(mcfDistinguishedIdentifier);
            }
        }
    }

    private static void checkStationNumber(String stationNumber) throws InstitutionMappingBadStationNumberException {
        int nextDigitPosToTest;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("looking up mapping for station # '" + stationNumber + "'."));
        }
        for (nextDigitPosToTest = 0; nextDigitPosToTest < stationNumber.length() && Character.isDigit(stationNumber.charAt(nextDigitPosToTest)); ++nextDigitPosToTest) {
        }
        int lastDigitPos = nextDigitPosToTest - 1;
        if (lastDigitPos < 2) {
            throw new InstitutionMappingBadStationNumberException("Station Number '" + stationNumber + "' not valid; numeric portion must be at least 3 digits.");
        }
        if (lastDigitPos + 1 < stationNumber.length()) {
            if (lastDigitPos != 2) {
                throw new InstitutionMappingBadStationNumberException("Station Number '" + stationNumber + "' not valid; only stations in the 200 range can have a non-numeric suffix.");
            }
            if (stationNumber.charAt(0) != '2') {
                throw new InstitutionMappingBadStationNumberException("Station Number '" + stationNumber + "' not valid; only stations in the 200 range can have a non-numeric suffix.");
            }
        } else if (lastDigitPos == 3 && stationNumber.charAt(3) != '9') {
            throw new InstitutionMappingBadStationNumberException("Station Number '" + stationNumber + "' not valid; if a 4th digit is present, it is treated as a suffix and can only be '9' for nursing homes.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMappingsForJndiName(String mcfJndiName, String[] mcfStationNumbers, long mcfDistinguishedIdentifier) {
        Object object = this.syncObjMapping;
        synchronized (object) {
            for (int i = 0; i < mcfStationNumbers.length; ++i) {
                InstitutionMappingVO imVO;
                logger.debug((Object)("considering removing station # " + mcfStationNumbers[i]));
                if (!this.institutionMap.containsKey(mcfStationNumbers[i]) || !(imVO = (InstitutionMappingVO)this.institutionMap.get(mcfStationNumbers[i])).getJndiName().equals(mcfJndiName) || imVO.getLastOneInMcfDistinguishedIdentifier() != mcfDistinguishedIdentifier) continue;
                this.institutionMap.remove(mcfStationNumbers[i]);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Removed mapping for station #'" + mcfStationNumbers[i] + "', JNDI name '" + mcfJndiName + "'."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJndiConnectorNameForInstitution(String stationNumber) throws InstitutionMapNotInitializedException, InstitutionMappingNotFoundException {
        InstitutionMappingVO imuVO = null;
        try {
            InstitutionMappingImpl me = InstitutionMappingImpl.getInstance();
            Object object = this.syncObjMapping;
            synchronized (object) {
                imuVO = (InstitutionMappingVO)me.institutionMap.get(stationNumber);
            }
            if (imuVO == null) {
                throw new InstitutionMappingNotFoundException("Could not match stationNumber '" + stationNumber + "' to an institution mapping.");
            }
        }
        catch (IllegalStateException e) {
            throw new InstitutionMapNotInitializedException("The InstitutionMappingImpl object has not been created.");
        }
        return imuVO.getJndiName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMappingClone() {
        TreeMap clone = null;
        Object object = this.syncObjMapping;
        synchronized (object) {
            clone = (TreeMap)this.institutionMap.clone();
        }
        return clone;
    }

    public Set getVistaLinkMappedStationNumberSet() {
        return Collections.unmodifiableSet(this.getMappingClone().keySet());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

