package gov.va.med.edp.web.view;

import org.springframework.web.servlet.view.AbstractView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

public class XmlView extends AbstractView {
    public static final String XML_FRAGMENT = "xmlFragment";

    public XmlView() {
        setContentType("text/xml;charset=utf-8");
    }

    protected void renderMergedOutputModel(Map map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpCacheControl.addNoCacheHeaders(response);

        response.getWriter().println("<?xml version='1.0' encoding='UTF-8'?>");
        response.getWriter().println("<results>");
        response.getWriter().println(map.get(XML_FRAGMENT));
        response.getWriter().println("</results>");
        response.getWriter().close();
    }
}
