package gov.va.med.edp.business
{
	import com.adobe.cairngorm.business.ServiceLocator;

    import gov.va.med.edp.business.responder.XMLResultFormattingResponder;
    import gov.va.med.edp.business.responder.ServerErrorCheckResponder;
	
	import mx.rpc.AsyncToken;
	import mx.rpc.IResponder;
	
	/**
	 * Base class for Cairngorm service delegates that sends IResponder methods
	 * to a chain of decorator responders which eventually forward result and fault methods
	 * to responder specified on construction. 
	 */
	public class ResponderChainingDelegate
	{
		private var responder:IResponder;
		private var service:Object;
		
		public function ResponderChainingDelegate(responder:IResponder, serviceName:String) {
            this.service = ServiceLocator.getInstance().getHTTPService(serviceName);
            this.responder = createResponderChain(responder);
		}
		
		protected function createResponderChain(lastResponder: IResponder) : IResponder {
			return new XMLResultFormattingResponder(new ServerErrorCheckResponder(lastResponder));
		}
		
		public final function send(params:Object = null) : void {
			var token:AsyncToken = service.send(params);
			token.addResponder(responder);
		}
	}
}