package gov.va.med.edp.business.responder
{
	import mx.rpc.Fault;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
    import mx.rpc.http.HTTPService;

    /**
     * Responder that takes a text result and attempts to create an XML object of it.  If an error during the XML parse
     * occurs, fault is called on the decorated responder, otherwise a new ResultEvent is created with result set to the
     * XML object. This emulates the behavior of setting the resultFormat on HTTPService to "e4x".
     */
    public class XMLResultFormattingResponder extends ResponderDecorator implements IResponder
	{	
		public function XMLResultFormattingResponder(responder: IResponder) {
			super(responder);
		}

		public override function result(data:Object):void {
            var resultEvent:ResultEvent = ResultEvent(data);
            try {
                var xml:XML = new XML(String(resultEvent.result));
                responder.result(new ResultEvent(ResultEvent.RESULT, resultEvent.bubbles, resultEvent.cancelable, xml, resultEvent.token, resultEvent.message));
			} catch (error:Error) {
                var fault:Fault = new Fault(HTTPService.ERROR_DECODING, error.message);
                fault.rootCause = String(resultEvent.result);
                var faultEvent:FaultEvent = FaultEvent.createEvent(fault);
                responder.fault(faultEvent);
            }
		}
    }
}