/*  Command
	event & command must be added to TrackingController.as    */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.AddPatientToLogDelegate;
	import gov.va.med.edp.control.PatientSelectEvent;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.util.Vista;
	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.collections.ArrayCollection;
	import mx.collections.Sort;
	import mx.collections.SortField;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	public class AddPatientToLogCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		public function execute(event:CairngormEvent):void
		{
			var delegate:AddPatientToLogDelegate = new AddPatientToLogDelegate(this);
			var addEvent:PatientSelectEvent = PatientSelectEvent(event);
			var localTime: String = Vista.DatetoFM(model.buildSiteDate());

			delegate.addPatientToLog(addEvent.newPatient, model.logArea, localTime, model.logEdit.choiceTS);
		}
		
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;

			if (xml.add.@status == "fail") {
				InfoDialog.show("Patient could not be added to the log: " + xml.add.@msg);
				return;
			}			
			
			// make sure the choices are set up before setting the logEntry
			model.logEdit.setChoices(xml.choices[0]);
			// now that the choices are in place, we can set the log entry
			model.logEdit.setEntry(TrackingFactory.buildLogEntryFromXML(xml.logEntry[0]));
			model.logEdit.entry.isStub = true;
            model.logEdit.dirty = true;
            model.setEditState();
			
			// refresh the list of log entries
			model.logEntryList.entries =
				new ArrayCollection(TrackingFactory.buildLogSelectorListFromXML(xml.logEntries.log));
			model.logEntryList.token = xml.logEntries.@token;
				
			// sort based on previous settings
			if (model.logEntryList.sortField.length > 0) {
				var sort:Sort = new Sort();
				sort.fields = [new SortField(model.logEntryList.sortField, true, model.logEntryList.sortDescending)];
				model.logEntryList.entries.sort = sort;
				model.logEntryList.entries.refresh();
			}
			// now that it is sorted, set the selected index to the just added patient
			// (must set initial -1 to fire bindings)
			model.logEntryList.selectedIndex = -1;
			model.logEntryList.selectedIndex = 
				Vista.locateIndex(model.logEntryList.entries, model.logEdit.entry.id, "id");
			model.logEntryList.selectedID = model.logEdit.entry.id;
			
			model.logEdit.patientSelected = true;
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Add patient to log failed: " + super.getFaultMessage(faultEvent);
		}
	}
}