/* InitTrackingCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.InitTrackingDelegate;
	import gov.va.med.edp.control.SwitchAppViewEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.LookupVO;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	
	public class InitTrackingCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();

		public function execute(event:CairngormEvent):void
		{
			var delegate: InitTrackingDelegate = new InitTrackingDelegate(this);
			delegate.initTracking(model.session.areaName);
		}
		
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;

            model.session.serverPackageVersion = xml.user[0].@version;
            if (model.session.area <= 0) {
	            model.session.area = xml.user[0].@area;
				model.session.areaName = xml.user[0].@areaNm;            	
            }

            model.logArea = model.session.area;  // set initial logArea value
			
			if (model.appName == TrackingModelLocator.APP_NAME_TRACKING) {
                var e:SwitchAppViewEvent = new SwitchAppViewEvent(SwitchAppViewEvent.EVENT_SWITCH_APP_VIEW);
				if (isVersionIncompatibility()) {
                    e.view = TrackingModelLocator.VIEW_APP_VERSION_INCOMPATIBILITY;
                } else if (model.appViewList.length > 0) {
					e.view = (model.appViewList[0] as LookupVO).data;
				}
				e.dispatch();
            } else if (model.appName == TrackingModelLocator.APP_NAME_BIGBOARD) {
                if (isVersionIncompatibility()) {
                    model.appViewState = TrackingModelLocator.VIEW_APP_VERSION_INCOMPATIBILITY;
                } else {
                    model.appViewState = TrackingModelLocator.VIEW_APP_DISPLAY_BOARD;
                }
            }
		}

        private function isVersionIncompatibility():Boolean {
            return model.appClientVersion != model.session.serverPackageVersion;
        }

        protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Unable to initialize tracking views: " + super.getFaultMessage(faultEvent);
		}
	}
}