/* SaveBedConfigCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.config.SaveBedConfigDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.factory.SessionFactory;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.RoomBedVO;
	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.collections.ArrayCollection;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	public class SaveBedConfigCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		public function execute(event:CairngormEvent): void
		{
			// clear filter so we don't miss any changes that might be hidden
			var bedFilter: Function = model.config.beds.filterFunction;
			if (bedFilter != null) {
				model.config.beds.filterFunction = null;
				model.config.beds.refresh();
			}
			
			// set the sequence based on the visible order in the datagrid	
			var i: int;
			var seq: int;
			var bed: RoomBedVO;
			for (i=0; i<model.config.beds.length; i++) {
				seq = (i+1)*10;
				bed = model.config.beds[i] as RoomBedVO;
				if (bed.sequence != seq) {
					bed.sequence = seq;
					bed.changed = true;
				}
			}
			
			// create a collection of the changed entries
			var saveBeds: ArrayCollection = new ArrayCollection();
			for (i=0; i<model.config.beds.length; i++) {
				bed = model.config.beds[i] as RoomBedVO;
				if (bed.changed) {
					saveBeds.addItem(bed);
				}
			}
			
			// reset filter to previous setting now that beds have been saved
			if (bedFilter != null) {
				model.config.beds.filterFunction = bedFilter;
				model.config.beds.refresh();
			}
			
			// now save the changed entries
			model.config.bedLoaded = false;
			var delegate: SaveBedConfigDelegate = new SaveBedConfigDelegate(this);
			delegate.saveBedConfig(saveBeds, model.logArea, model.config.bedToken);
		}
		
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			if ((xml.save.@status == "ok") || (xml.save.@status == "collide")) {
				model.config.beds = 
					TrackingFactory.buildRoomBedListFromXML(xml.beds.bed);
				model.config.defaultRoomList =
					SessionFactory.buildLookupListFromXML(xml.defaultRoomList.item);
				model.config.bedToken = xml.bedToken;
				model.config.bedMods = false;
				model.config.bedLoaded = true;
				
				if (xml.save.@status == "ok") {
					InfoDialog.show("New room/bed configuration saved.");
				} else {
					InfoDialog.show("Save failed: " + xml.save);
				}
			}
			
			if (xml.save.@status == "fail") {
				InfoDialog.show("Save failed: " + xml.save);
			}
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error saving configuration for rooms / beds: " + super.getFaultMessage(faultEvent);
		}
	}
}