/* SaveConfigBoardCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.config.SaveConfigBoardDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.control.config.BoardConfigEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.ColumnSpecVO;
	import gov.va.med.edp.widget.InfoDialog;
	import gov.va.med.edp.util.BoardTools;
	import gov.va.med.edp.factory.SessionFactory;
	import gov.va.med.edp.util.Vista;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	public class SaveConfigBoardCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		public function execute(event:CairngormEvent):void
		{
			var delegate: SaveConfigBoardDelegate = new SaveConfigBoardDelegate(this);
			var saveEvent: BoardConfigEvent = BoardConfigEvent(event);
			
			var xml:XML = <spec />;
			var row:XML = <row />;
			row.@color = model.config.rowColorMap.id;
			xml.appendChild(row);
			
			var displayProperties:XML = <displayProperties />;
			displayProperties.@fontSize = model.config.displayBoardProperties.fontSize;
			displayProperties.@displayWidth = model.config.displayBoardProperties.displaySize.width;
			displayProperties.@displayHeight = model.config.displayBoardProperties.displaySize.height;
			displayProperties.@displayLabel = model.config.displayBoardProperties.displaySize.label;
			displayProperties.@scrollDelay = model.config.displayBoardProperties.scrollDelay;
			displayProperties.@squish = model.config.displayBoardProperties.squish;
			xml.appendChild(displayProperties);
			
			var colSpec: ColumnSpecVO;
			for (var i:int = 0; i < model.config.columns.length; i++) {
				colSpec = model.config.columns[i] as ColumnSpecVO;
				var node:XML = <col />;
				node.@att = colSpec.attribute;
				node.@header = colSpec.header;
				node.@color = (colSpec.colorMap != null) ? colSpec.colorMap.id : "";
				node.@width = colSpec.width;
				node.@label = colSpec.label;
				xml.appendChild(node);
			}
			model.config.boardLoaded = false;
			delegate.saveConfigBoard(model.logArea, saveEvent.boardID, saveEvent.boardName, model.config.boardToken, xml);
		}
		
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	

			if ((xml.save.@status == "ok")|| (xml.save.@status == "collide")) {
				BoardTools.applyBoardSpec(model.config, xml);
				model.config.boardLoaded = true;			

				if (xml.save.@status == "ok") {
					InfoDialog.show("New board colors saved.");
				} else {
					InfoDialog.show("Save failed: " + xml.save);
				}				
			}

			if (xml.save.@status == "fail") {
				InfoDialog.show("Save failed: " + xml.save);
			}
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error saving configuration for display board: " + super.getFaultMessage(faultEvent);
		}
	}
}