ECHO OFF
CLS


SET COMP_NAME=%computername%
SET TEMP_CERT_NAME=EdisClientCert.tmp


REM copy the certificate from system store to temp file
ECHO Copying %COMP_NAME% certificate from the system store to temp file ((%TEMP_CERT_NAME%))...."
certmgr -add -c -s -r localMachine -n %COMP_NAME% my -r currentUser %TEMP_CERT_NAME%
ping -n 2 127.0.0.1 >NUL
IF EXIST %TEMP_CERT_NAME% GOTO FILECREATED
GOTO EXITPROCESS

:EXITPROCESS
ECHO Copying certificate process FAILED...
ECHO .
ECHO A unique certificate with subject name "%COMP_NAME%"  does not exist in the machine certificate store..
ECHO .     
ECHO Unable to launch EDIS BigBoard..
ECHO Exiting process..
ping -n 15 127.0.0.1 >NUL
EXIT


:FILECREATED
ECHO Copy from system store to temp file (%TEMP_CERT_NAME%) SUCCESSFUL

REM Clear the user store
ECHO Removing any previous certificates from the user store..
certmgr -del -all -c -s my
ECHO Removal of previous certificates from the user store SUCCESSFUL


REM copy the certificate from temp file (%TEMP_CERT_NAME%) to user store
ECHO Copying %COMP_NAME% certificate from temp file to user store...
certmgr -add -c %TEMP_CERT_NAME% -s -r currentUser my
ping -n 2 127.0.0.1 >NUL
ECHO Copy from temp file (%TEMP_CERT_NAME%) to user store SUCCESSFUL



REM Remove the temporary file if it exists
ECHO Removing the tmp file (%TEMP_CERT_NAME%) from the disk...
IF EXIST %TEMP_CERT_NAME% DEL %TEMP_CERT_NAME%
ECHO Removal of tmp file (%TEMP_CERT_NAME%) from the disk SUCCESSFUL

REM STAGING URL  https://staging.edis.med.va.gov:8080/bigboard/
REM PRODUCTION URL https://vaww.edis.med.va.gov:8080/bigboard
REM TESTING URL https://vhaislbll2.vha.med.va.gov:7701/bigboard/
REM DEV URL https://vhaislbll2.vha.med.va.gov:7741/bigboard/


REM Launch IE in Kiosk Mode pointing to a certain URL
ECHO .
ECHO Launching IE in Kiosk Mode for EDIS BigBoard, URL is: 
ECHO https://vaww.edis.med.va.gov:8080/bigboard
ping -n 5 127.0.0.1 >NUL
START iexplore.exe -k https://vaww.edis.med.va.gov:8080/bigboard


ECHO ON