package gov.va.med.edp.dao.rpc;

import gov.va.med.edp.rpc.AbstractVistaLinkConnectionTest;

import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;

public class VistaLinkBigBoardDaoTest extends AbstractVistaLinkConnectionTest {
    private VistaLinkBigBoardDao dao;

    protected String getStationNumber() {
        return "500";
    }

    protected void setUp() throws Exception {
        super.setUp();

        dao = new VistaLinkBigBoardDao();
        dao.setConnectionFactoryLocator(mockConnectionFactoryLocator);
        dao.afterPropertiesSet();
    }

    public void testExecuteCommand() {
        expectVistaLinkAppProxyConnection(VistaLinkBigBoardDao.EDPTRACKING_APPLICATION_USER);

        List params = new ArrayList();
        params.add("0^500");
        params.add(new HashMap());
        expectRpcAndReturn(VistaLinkBigBoardDao.EDPS_BOARD_CONTEXT, VistaLinkBigBoardDao.EDP_CONTROLLER_BOARD_RPC, params, "bar");

        replay();

        String result = dao.executeCommand("500", null, new HashMap());
        assertEquals("bar", result);

        verify();
    }
}
