package gov.va.med.edp.dao.rpc;

import junit.framework.TestCase;
import gov.va.med.edp.rpc.AbstractVistaLinkConnectionTest;

import java.util.HashMap;
import java.util.ArrayList;
import java.util.List;

/**
 * TODO: document VistaLinkServerPackageVersionDaoTest
 */
public class VistaLinkServerPackageVersionDaoTest extends AbstractVistaLinkConnectionTest {
    private VistaLinkServerPackageVersionDao dao;

    protected String getStationNumber() {
        return "500";
    }

    protected void setUp() throws Exception {
        super.setUp();

        dao = new VistaLinkServerPackageVersionDao();
        dao.setConnectionFactoryLocator(mockConnectionFactoryLocator);
        dao.afterPropertiesSet();
    }

    public void testExecuteCommand() {
        expectVistaLinkAppProxyConnection(VistaLinkBigBoardDao.EDPTRACKING_APPLICATION_USER);

        HashMap multiple = new HashMap();
        multiple.put("command", "initTracking");        

        List params = new ArrayList();
        params.add("0^" + getStationNumber());
        params.add(multiple);
        expectRpcAndReturn(VistaLinkBigBoardDao.EDPS_BOARD_CONTEXT, VistaLinkBigBoardDao.EDP_CONTROLLER_BOARD_RPC, params, "<user foo=\"bar\" version=\"0.4-T4-SNAPSHOT\"/>");

        replay();

        String result = dao.getServerPackageVersion(getStationNumber());
        assertEquals("0.4-T4-SNAPSHOT", result);

        verify();
    }
}
