package gov.va.med.edp.dao.rpc;

import gov.va.med.edp.rpc.AbstractVistaLinkConnectionTest;

import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;

public class VistaLinkTrackingDaoTest extends AbstractVistaLinkConnectionTest {
    private VistaLinkTrackingDao dao;

    protected String getStationNumber() {
        return "500";
    }

    protected void setUp() throws Exception {
        super.setUp();

        dao = new VistaLinkTrackingDao();
        dao.setConnectionFactoryLocator(mockConnectionFactoryLocator);
        dao.afterPropertiesSet();
    }

    public void testExecuteCommand() {
        expectVistaLinkDuzConnection("foo");

        List params = new ArrayList();
        params.add(new HashMap());
        expectRpcAndReturn(VistaLinkTrackingDao.EDPF_TRACKING_SYSTEM_CONTEXT, VistaLinkTrackingDao.EDP_CONTROLLER_RPC, params,"bar");

        replay();

        String result = dao.executeCommand("500", "foo", new HashMap());
        assertEquals("bar", result);

        verify();
    }
}
