/* InitLogAreaCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.InitLogAreaDelegate;
	import gov.va.med.edp.control.InitLogAreaEvent;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.collections.ArrayCollection;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	public class InitLogAreaCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		public function execute(event:CairngormEvent):void
		{
			var delegate:InitLogAreaDelegate = new InitLogAreaDelegate(this);
			var initEvent:InitLogAreaEvent = InitLogAreaEvent(event);
			model.logArea = initEvent.area;
			delegate.initLogArea(initEvent.area, initEvent.logEntrySave);
		}
		
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;
			
			if (xml.udp.@status == "fail") {
				InfoDialog.show("Update failed: " + xml.upd.@msg);
				return;
			}
			
			model.logEditParams = TrackingFactory.buildLogEditParamsFromXML(XML(xml.params));
			
			if (xml.logEntries.@status == "new") {
				model.logEntryList.entries =
					new ArrayCollection(TrackingFactory.buildLogSelectorListFromXML(xml.logEntries.log));
				model.logEntryList.token = xml.logEntries.@token;
				model.logEntryList.selectedIndex = -1;
				model.logEntryList.sortField = "";
				model.logEntryList.sortDescending = false;
				model.logEntryViewState = TrackingModelLocator.VIEW_EDIT_MESSAGE;
				//from AutoSave: model.editorViewState = TrackingModelLocator.VIEW_EDIT_MESSAGE;
			}
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Unsuccessful save command: " + super.getFaultMessage(faultEvent);
		}
		
		public override function fault(info:Object):void
		{
			super.fault(info);
		}
	}
}