/* ResetDisplayBoardCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.ResetDisplayBoardDelegate;
	import gov.va.med.edp.control.DisplayBoardEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.ResultEvent;

	public class ResetDisplayBoardCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		public function execute(event:CairngormEvent):void
		{
			var delegate:ResetDisplayBoardDelegate = new ResetDisplayBoardDelegate(this);
			var resetEvent: DisplayBoardEvent = DisplayBoardEvent(event);
			delegate.resetDisplayBoard(model.session.area, resetEvent.name);
		}
		
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			// process the xml
		}
		
		public override function fault(info:Object):void
		{
			InfoDialog.show("Unable to load display board spec.");
		}
	}
}