/* LoadActivityReportCommand.as */
	
package gov.va.med.edp.command.reports
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.reports.ReportDelegate;
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.factory.ReportFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import mx.rpc.IResponder;
	import mx.rpc.events.ResultEvent;

	public class LoadDelayReportCommand extends BaseReportCommand
	{
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			// process the xml
			//add delay logs to model
			model.reports.delayReport.delayLogs = ReportFactory.buildReportLogEntriesFromXML(xml.logEntries.log);
			
			//fire the binding..
			model.reports.reportType = "";
			model.reports.reportType = ReportEvent.EVENT_DELAY_REPORT;
		}
		
	}
}