/* ColorCellRenderer.as */

package gov.va.med.edp.widget
{
	import flash.display.Graphics;
	
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.controls.Label;
	
	public class ColorCellRenderer extends Label
	{	
		[Bindable]
		private var model: TrackingModelLocator = TrackingModelLocator.getInstance();

		override public function set data(value:Object):void
		{
			super.data = value;

			if (value != null)
			{
				setStyle("color", model.boardSpec.cellColor(listData["dataField"], value).text);
				if (model.appName == TrackingModelLocator.APP_NAME_BIGBOARD) {
					setStyle("fontSize", model.boardSpec.displayBoardProperties.squishFontSize);					
				}
			}
		}
		
		override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number):void
		{
			super.updateDisplayList(unscaledWidth, unscaledHeight);
			
			if (data != null) {
				var backColor: uint = model.boardSpec.cellColor(listData["dataField"], data).back;
				var g:Graphics = graphics;
				g.clear();
				g.beginFill(backColor);
				//g.drawRect(0, -2, unscaledWidth, unscaledHeight+4);
				g.drawRect(0, 0, unscaledWidth, unscaledHeight);
				g.endFill();				
			}
		}
	}
}