/* GapAccordion.as

In Flex 2 there is a bug that causes the verticalGap to not be included in the
measurement calculations for the child containers in the accordion.  This
adds the verticalGap back in.

See:  http://adamflater.blogspot.com/2007/08/accordion-bug.html

 */
 
package gov.va.med.edp.widget
{
	import mx.containers.Accordion;

	public class GapAccordion extends Accordion
	{
	
		override protected function measure():void
		{
			super.measure();
			this.measuredHeight += (this.getStyle("verticalGap") * this.numChildren);
		}
		
	}
}