package gov.va.med.edp.dao.rpc;

import gov.va.med.edp.dao.SessionDao;
import gov.va.med.edp.vo.SessionVO;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

public class VistaLinkSessionDao extends VistaLinkTrackingDao implements SessionDao {
    private static final String UNABLE_TO_GET_USER_INFO = "unable to get user info";

    public SessionVO getSessionInfo(String stationNumber, String duz) throws DataAccessException {
        Map params = new HashMap();
        params.put("command", "initUser");
        String result = executeCommand(stationNumber, duz, params);
        return createSessionInfo(result);
    }

    private SessionVO createSessionInfo(String result) {
        Document doc = buildDocument(result);

        SessionVO session = new SessionVO();
        session.setServerPackageVersion(getServerPackageVersion(doc));
        session.setTimeOutMillis(Integer.parseInt(getTimeout(doc)));
        session.setCountDownMillis(Integer.parseInt(getCountdown(doc)));
        return session;
    }

    private String getServerPackageVersion(Document doc) {
        return getUserElement(doc).getAttribute("version");
    }

    private String getTimeout(Document doc) {
        return getUserElement(doc).getAttribute("timeOut");
    }

    private Element getUserElement(Document doc) {
        return ((Element) doc.getDocumentElement().getElementsByTagName("user").item(0));
    }

    private String getCountdown(Document doc) {
        return getUserElement(doc).getAttribute("countDown");
    }

    private Document buildDocument(String result) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader("<results>" + result + "</results>")));
        } catch (ParserConfigurationException e) {
            throw new DataRetrievalFailureException(UNABLE_TO_GET_USER_INFO, e);
        } catch (IOException e) {
            throw new DataRetrievalFailureException(UNABLE_TO_GET_USER_INFO, e);
        } catch (SAXException e) {
            throw new DataRetrievalFailureException(UNABLE_TO_GET_USER_INFO, e);
        }
    }

    
}
