package gov.va.med.edp.rpc;

import org.springframework.dao.support.DaoSupport;

public class VistaLinkDaoSupport extends DaoSupport {

    private VistaLinkRpcTemplate rpcTemplate;

    protected void checkDaoConfig() throws IllegalArgumentException {
        if (this.rpcTemplate == null) {
			setConnectionFactoryLocator(new InstitutionMappingConnectionFactoryLocator());
		}
    }

    protected VistaLinkRpcTemplate createRpcTemplate(ConnectionFactoryLocator connectionFactoryLocator) {
        return new VistaLinkRpcTemplate(connectionFactoryLocator);
    }

    public ConnectionFactoryLocator getConnectionFactoryLocator() {
        return rpcTemplate.getConnectionFactoryLocator();
    }

    public void setConnectionFactoryLocator(ConnectionFactoryLocator connectionFactoryLocator) {
        setRpcTemplate(createRpcTemplate(connectionFactoryLocator));
    }

    public VistaLinkRpcTemplate getRpcTemplate() {
        return rpcTemplate;
    }

    public void setRpcTemplate(VistaLinkRpcTemplate rpcTemplate) {
        this.rpcTemplate = rpcTemplate;
    }
}
