package gov.va.med.edp.web.controller;

import gov.va.med.edp.dao.ServerPackageVersionDao;
import gov.va.med.edp.dao.SiteCodeLookUpDao;
import gov.va.med.edp.dao.TrackingDao;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;

import org.easymock.MockControl;

/**
 * TODO: document BigBoardClientVersionSynchronizationControllerTest
 */
public class BigBoardClientVersionSynchronizationControllerTest extends AbstractControllerTest {

    protected void setUp() throws Exception {
        super.setUp();

        request.setUserPrincipal(new Principal() {
            public String getName() {
                return "ISL-DHARS1-LT";
            }
        });
        request.setParameter("machineName", "ISL-DHARS1-LT");
      
    }

    public void testNoServerPackageVersionInSessionResultsInCallToDataAccessObject() throws Exception {
        MockControl mockDaoControl = MockControl.createControl(ServerPackageVersionDao.class);
        MockControl siteDaoControl = MockControl.createControl(SiteCodeLookUpDao.class);
        MockControl trackingDaoControl = MockControl.createControl(TrackingDao.class);

        
        ServerPackageVersionDao mockDao = (ServerPackageVersionDao) mockDaoControl.getMock();
        SiteCodeLookUpDao siteCodeDao = (SiteCodeLookUpDao) siteDaoControl.getMock();
        TrackingDao trackingDao = (TrackingDao) trackingDaoControl.getMock();
        
        
        BigBoardClientVersionSynchronizationController c = new BigBoardClientVersionSynchronizationController();
        c.setApplicationContext(webAppContext);
        c.setClientArtifactId("foo-bar");
        c.setViewName("bazView");
        c.setServerPackageVersionDao(mockDao);
        c.setSiteCodeDao(siteCodeDao);
        c.setTrackingDao(trackingDao);
        c.afterPropertiesSet();

        Map params = new HashMap();
        params.put("machine", "ISL-DHARS1-LT");
        trackingDaoControl.expectAndDefaultReturn(trackingDao.executeCommand("968", "0", params), "<result>some result message</result>");
        trackingDaoControl.replay();        
        
        
        siteDaoControl.expectAndDefaultReturn(siteCodeDao.getSiteCode("ISL-DHARS1-LT"), "968");
        siteDaoControl.replay();
        
        mockDaoControl.expectAndReturn(mockDao.getServerPackageVersion("968"), "1.0-T99");
        mockDaoControl.replay();
        
        c.handleRequest(request, response);
        trackingDaoControl.verify();
        siteDaoControl.verify();

        assertEquals("1.0-T99", session.getAttribute(SessionConstants.SERVER_PACKAGE_VERSION_KEY));

        c.handleRequest(request, response);  // now in session so no call to dao is made

        mockDaoControl.verify();
    }
}
