package gov.va.med.edp.web.controller;

import org.springframework.web.servlet.ModelAndView;
public class LogoutControllerTest extends AbstractControllerTest {

    public void testDefaultViewName() throws Exception {
        LogoutController c = new LogoutController();
        c.afterPropertiesSet();
        ModelAndView mav = c.handleRequest(request, response);
        assertEquals(LogoutController.DEFAULT_VIEW_NAME, mav.getViewName());
    }

    public void testViewName() throws Exception {
        LogoutController c = new LogoutController();
        c.setViewName("foo");
        c.afterPropertiesSet();
        ModelAndView mav = c.handleRequest(request, response);
        assertEquals("foo", mav.getViewName());
    }

    public void testInvalidateSession() throws Exception {
        LogoutController c = new LogoutController();
        c.afterPropertiesSet();
        c.handleRequest(request, response);
        assertTrue(session.isInvalid());
    }

    public void testLogoutSeveralClients() throws Exception {
        session.setAttribute(SessionConstants.RECOGNIZED_SWF_IDS_KEY, "foo,bar,baz");

        LogoutController c = new LogoutController();
        c.afterPropertiesSet();

        request.setParameter("swfID", "foo");

        c.handleRequest(request, response);
        assertFalse(session.isInvalid());

        request.setParameter("swfID", "bar");

         c.handleRequest(request, response);
        assertFalse(session.isInvalid());

        request.setParameter("swfID", "baz");

        c.handleRequest(request, response);
        assertTrue(session.isInvalid());
    }
}
