package gov.va.med.edp.springframework.security.userdetails.memory;

import gov.va.med.edp.springframework.security.userdetails.VistaUserDetails;
import gov.va.med.edp.springframework.security.userdetails.VistaUserDetailsService;
import org.springframework.security.BadCredentialsException;
import org.springframework.dao.DataAccessException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class InMemoryDaoImpl implements VistaUserDetailsService, InitializingBean {

    private VistaUserMap userMap;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.userMap,
            "A list of user duz, station numbers, access/verify codes, enabled/disabled status and their granted authorities must be set");
    }

    public VistaUserDetails login(String stationNumber, String accessCode, String verifyCode, String remoteAddress) throws BadCredentialsException, DataAccessException {
        return userMap.getUser(stationNumber, accessCode, verifyCode);
    }

    public void logout(VistaUserDetails user) throws DataAccessException {
        // NOOP
    }

    public VistaUserMap getUserMap() {
        return userMap;
    }

    public void setUserMap(VistaUserMap userMap) {
        this.userMap = userMap;
    }
}
