package gov.va.med.edp.springframework.security.userdetails.memory;

import junit.framework.TestCase;
import gov.va.med.edp.springframework.security.userdetails.VistaUserDetails;
import org.easymock.MockControl;

public class VistaUserMapTest extends TestCase {
    public void testConstruct() {
        VistaUserMap userMap = new VistaUserMap();
        assertEquals(0, userMap.getUserCount());
    }

    public void testAddUser() {
        VistaUserMap userMap = new VistaUserMap();
        VistaUserDetails u = createUser("12345", "982", "FOO", "BAR");
        userMap.addUser(u);
        assertEquals(1, userMap.getUserCount());
        assertSame(u, userMap.getUser("982", "FOO", "BAR"));
    }

    private VistaUserDetails createUser(String duz, String stationNumber, String access, String verify) {
        MockControl mockUserControl = MockControl.createControl(VistaUserDetails.class);
        VistaUserDetails user = (VistaUserDetails) mockUserControl.getMock();
        mockUserControl.expectAndDefaultReturn(user.getDuz(), duz);
        mockUserControl.expectAndDefaultReturn(user.getLoginStationNumber(), stationNumber);
        mockUserControl.expectAndDefaultReturn(user.getPassword(), access + ";" + verify);
         mockUserControl.replay();
        return (VistaUserDetails) mockUserControl.getMock();
    }
}

/* this is the source for when we move to java 5 and later easymock version
import gov.va.med.edp.springframework.security.userdetails.VistaUserDetails;
import gov.va.med.edp.springframework.security.userdetails.memory.VistaUserMap;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import static org.easymock.EasyMock.expect;
import static org.easymock.EasyMock.createMock;

public class VistaUserMapTest extends TestCase {

    public void testConstruct() {
        VistaUserMap userMap = new VistaUserMap();
        assertEquals(0, userMap.getUserCount());
    }

    public void testAddUser() {
        VistaUserMap userMap = new VistaUserMap();
        VistaUserDetails u = createUser("12345", "982", "FOO", "BAR");
        userMap.addUser(u);
        assertEquals(1, userMap.getUserCount());
        assertSame(u, userMap.getUser("982", "FOO", "BAR"));
    }

    private VistaUserDetails createUser(String duz, String stationNumber, String access, String verify) {
        VistaUserDetails user = createMock(VistaUserDetails.class);
        expect(user.getDuz()).andReturn(duz).anyTimes();
        expect(user.getLoginStationNumber()).andReturn(stationNumber).anyTimes();
        expect(user.getPassword()).andReturn(access + ";" + verify).anyTimes();
        EasyMock.replay(user);
        return user;
    }
}
*/