package gov.va.med.edp.springframework.security.userdetails.vistalink;

import junit.framework.TestCase;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import gov.va.med.edp.springframework.security.userdetails.vistalink.VistaUser;

public class VistaUserTest extends TestCase {
    private VistaUser user;

    protected void setUp() throws Exception {
        user = new VistaUser("1221.98897654", "982", "12345", "10BAZ", "BAZ10", "BAR,FOO", "Foo Bar", "FOO", null, "BAR", "Mr.", null, "MD", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_BARNEY"), new GrantedAuthorityImpl("ROLE_FRED")});
    }

    public void testConstruct() {
        assertEquals("1221.98897654", user.getSignonLogInternalEntryNumber());
        assertEquals("982", user.getLoginStationNumber());
        assertEquals("12345", user.getDuz());
        assertEquals("BAR,FOO", user.getPersonName());
        assertEquals("Foo Bar", user.getDisplayName());
        assertEquals("FOO", user.getGivenName());
        assertEquals("BAR", user.getFamilyName());
        assertNull(user.getMiddleName());
        assertEquals("Mr.", user.getPrefix());
        assertNull(user.getSuffix());
        assertEquals("MD", user.getDegree());
        assertTrue(user.isEnabled());
        assertTrue(user.isAccountNonExpired());
        assertTrue(user.isAccountNonLocked());
        assertTrue(user.isCredentialsNonExpired());
        assertEquals(2, user.getAuthorities().length);
    }

    public void testUsername() {
        assertEquals("12345@982", user.getUsername());
    }

    public void testPassword() {
        assertEquals("10BAZ;BAZ10", user.getPassword());
    }
}
