/* ChangeLogEntryFieldCommand.as */
   	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.control.ChangeLogEntryFieldEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.pt.demog.model.PatientSelectVO;
	import gov.va.med.edp.vo.LogSelectorVO;
	import gov.va.med.edp.vo.PCECodedValueVO;

	public class ChangeLogEntryFieldCommand implements ICommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		public function execute(event:CairngormEvent):void
		{
			var changeEvent:ChangeLogEntryFieldEvent = ChangeLogEntryFieldEvent(event);
			model.logEdit.dirty = true;

			switch(changeEvent.field)
			{
				case "patient":
					// set the name, ssn, and dfn all at once
					var patientVO: PatientSelectVO = changeEvent.value as PatientSelectVO;
					if ((model.logEdit.entry != null && model.logEdit.entry.name == "(ambulance)") && 
						(patientVO.name != "(ambulance)") &&
						(model.logEdit.entry.inTS == null) ) {
						model.logEdit.entry.inTS = model.buildSiteDate();
						model.logEdit.patientSelected = true;	
					}
					model.logEdit.entry.name = patientVO.name;
					model.logEdit.entry.ssn = patientVO.ssn;
					model.logEdit.entry.dob = patientVO.dob;
					model.logEdit.entry.dfn = patientVO.dfn;
					synchSelector("name", patientVO.name);
					synchSelector("ssn", patientVO.ssn);
					break;
				case "name":
					model.logEdit.entry.name = changeEvent.value;
					synchSelector(changeEvent.field, changeEvent.label);
					break;
				case "ssn":
					model.logEdit.entry.ssn = changeEvent.value;
					synchSelector(changeEvent.field, changeEvent.label);
					break;
				case "inTS":
					model.logEdit.entry.inTS = changeEvent.value;
					model.logEdit.entry.requireDelay = isDelayRequired();
					break;
				case "outTS":
					model.logEdit.entry.outTS = changeEvent.value;
					model.logEdit.entry.requireDelay = isDelayRequired();
					break;
				case "complaint":
					model.logEdit.entry.complaint = changeEvent.value;
					break;
				case "longComplaint":
					model.logEdit.entry.longComplaint = changeEvent.value;
					break;
				case "arrival":
					model.logEdit.entry.arrival = changeEvent.value;
					break;
				case "bed":
					model.logEdit.entry.bed = changeEvent.value;
					if (int(changeEvent.reference) > 0) {
						model.logEdit.entry.status = int(changeEvent.reference);
					} else {
						if (model.logEdit.undo != null) {
							model.logEdit.entry.status = model.logEdit.undo.status;
						}
					}
					// don't synch until "save"
					// synchSelector(changeEvent.field, changeEvent.label);
					break;
				case "acuity":
					model.logEdit.entry.acuity = changeEvent.value;
					break;
				case "clinic":
					model.logEdit.entry.clinic = changeEvent.value;
					break;
				case "status":
					model.logEdit.entry.status = changeEvent.value;
					break;
				case "provider":
					model.logEdit.entry.provider = changeEvent.value;
					break;
				case "resident":
					model.logEdit.entry.resident = changeEvent.value;
					break;
				case "nurse":
					model.logEdit.entry.nurse = changeEvent.value;
					break;
				case "comment":
					model.logEdit.entry.comment = changeEvent.value;
					break;
				case "disposition":
					model.logEdit.entry.disposition = changeEvent.value;
					model.entryRemoveReady();
					break;
				case "delay":
					model.logEdit.entry.delay = changeEvent.value;
					model.entryRemoveReady();
					break;
				case "diagnoses":
					var pceItem: PCECodedValueVO = changeEvent.value as PCECodedValueVO;
					if (changeEvent.clear) {
						// clear means we want to remove the item
						var index: int = model.logEdit.entry.diagnoses.getItemIndex(pceItem);
						if (pceItem.added) {
							// remove from list if we just added it in this session
							model.logEdit.entry.diagnoses.removeItemAt(index);
						} else {
							// otherwise set remove to true so PCE can remove it
							model.logEdit.entry.diagnoses[index].remove = true;
						}
					} else if (pceItem.updated){ // MAKE SURE THAT UPDATE IS CHECKED BEFORE ADD..
						pceItem.updated = true	// BECAUSE AN ITEM CAN BE ADDED AND THEN UPDTED IN THE SAME SESSION
						model.logEdit.entry.diagnoses[index].updated = true;
					} else if (pceItem.added){
						pceItem.added = true;
						model.logEdit.entry.diagnoses.addItem(pceItem);
					} 
					model.logEdit.entry.updatedDiagnoses = true;
					model.entryRemoveReady();
					break;
			} // switch
		} // execute
		
		private function synchSelector(field: String, label: String): void
		{
			var logSelector: LogSelectorVO = findLogSelector();
			if (logSelector == null) return;
			
			switch(field)
			{
				case "name":
					logSelector.name = label;
					break;
				case "ssn":
					logSelector.ssn = label;
					break;
				case "bed":
					logSelector.bed = label;
					break;
			} // switch
		} // synchSelector
		
		private function findLogSelector(): LogSelectorVO
		{
			for each (var logSelector: LogSelectorVO in model.logEntryList.entries) {
				if (logSelector.id == model.logEdit.entry.id) {
					return logSelector;
				}
			}
			return null;		
		}
		
		private function isDelayRequired(): Boolean
		{
			if (!model.logEditParams.requireDelay) return false;
			
			// don't require delay reason for "entered in error"
			if (model.logEdit.entry.disposition == model.logEditParams.errorIEN) return false;
			
			var mins: Number = (model.logEdit.entry.outTS.valueOf() - model.logEdit.entry.inTS.valueOf()) / 60000;  // milliseconds to minutes
			return (mins > model.logEditParams.delayMinutes) ? true : false;
		}
		
	} // class
} // package