/* SwitchLogEntryCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.SwitchLogEntryDelegate;
	import gov.va.med.edp.control.SwitchLogEntryEvent;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import gov.va.med.edp.vo.LogEntryVO;

	public class SwitchLogEntryCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		public function execute(event:CairngormEvent): void
		{
			var delegate:SwitchLogEntryDelegate = new SwitchLogEntryDelegate(this);
			var switchEvent:SwitchLogEntryEvent = SwitchLogEntryEvent(event);
			
			model.logEntryList.selectedIndex = switchEvent.selectedIndex;
			model.logEntryList.selectedID = switchEvent.logID;
			
			delegate.switchLogEntry(switchEvent.logID, null, model.logEdit.choiceTS);
		}
		
		public override function result(data:Object): void
		{
			var xml:XML = ResultEvent(data).result as XML;
			
			// make sure the choices are set up before setting the logEntry
			model.logEdit.setChoices(xml.choices[0]);
			
			// now that the choices are in place, we can set the log entry
			model.logEdit.setEntry(TrackingFactory.buildLogEntryFromXML(xml.logEntry[0]));
			model.logEdit.undo = new LogEntryVO;  // used for resetting status right now
			model.logEdit.entry.copyTo(model.logEdit.undo);
			model.logEdit.dirty = false;
			model.logEdit.patientSelected = false;
			model.entryRemoveReady();
			model.setEditState();
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Loading log entry failed: " + super.getFaultMessage(faultEvent);
		}
		
		public override function fault(info:Object): void
		{
			model.synchToLastEntry();
			super.fault(info);
		}
		
	} // class
} // package