package gov.va.med.edp.pt.demog.model
{
import gov.va.med.edp.pt.demog.*;
	import com.adobe.cairngorm.vo.IValueObject;
	
	import mx.collections.ArrayCollection;

	[Bindable]
	public class PatientCheckVO implements IValueObject
	{
		public var dfn: String;
		public var sensitive: Boolean = false;  	// display sensitive warning
		public var mayAccess: Boolean = true;		// prevent access to own record
		public var logAccess: Boolean = false;		// must log access to patient
		public var onBoardText: String = "";		// patient is already on the board
		public var warningText: String = "";		// sensitive warning text to display
		public var similarText: String = "";		// similar patient warning text
		public var deceasedText: String = "";		// display deceased warning
		public var similarNames: Array;				// array of PatientSelectVO
		public var flags: ArrayCollection;			// array of PatientRecordFlagVO

        public function isOnBoard():Boolean {
            return onBoardText.length > 0;
        }

        public function hasSimilarNames():Boolean {
            return similarNames != null && similarNames.length > 0;
        }

        public function isDeceased():Boolean {
            return deceasedText.length > 0;
        }

        public function hasFlags():Boolean {
            return flags != null && flags.length > 0
        }
	}
}
