package gov.va.med.edp.widget
{
	import gov.va.med.edp.skins.LinkButtonTabSkin;
	
	import mx.controls.Button;
	import mx.core.mx_internal;
	import mx.styles.CSSStyleDeclaration;
	import mx.styles.StyleManager;
	
	use namespace mx_internal;
	
	public class LinkButtonTab extends Button
	{
		private static var classConstructed:Boolean = classConstruct();
	
		private static function classConstruct():Boolean {
			// If there is no CSS definition for our style,
			// then create one and set the default value.
			
			if (!StyleManager.getStyleDeclaration("LinkButtonTab"))
			{
				var style:CSSStyleDeclaration = new CSSStyleDeclaration();
				style.defaultFactory = function():void {
					this.skin = LinkButtonTabSkin;
					
					this.upSkin = LinkButtonTabSkin;
					this.downSkin = LinkButtonTabSkin;
					this.disabledSkin = LinkButtonTabSkin;
					this.overSkin = LinkButtonTabSkin;
					this.selectedUpSkin = LinkButtonTabSkin;
					this.selectedDownSkin = LinkButtonTabSkin;
					this.selectedOverSkin = LinkButtonTabSkin;
					this.selectedDisabledSkin = LinkButtonTabSkin;				
				}
				StyleManager.setStyleDeclaration("LinkButtonTab", style, true);
			}
			return true;
		}
			
		public function LinkButtonTab()
		{
			super();
			// Tabs are not tab-enabled.
			// The TabNavigator handles all focus management.
			focusEnabled = false;
		}

		override protected function updateDisplayList(unscaledWidth:Number,
												  unscaledHeight:Number):void
		{
			super.updateDisplayList(unscaledWidth, unscaledHeight);
	
			if (currentIcon)
			{
				currentIcon.scaleX = 1.0;
				currentIcon.scaleY = 1.0;
			}
	
			viewIcon();
		}
	}
}